<!DOCTYPE html>
<html lang="pt-br">
<head>
	<?php require 'analitycshead.php'; ?>
	<base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">
	<meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="robots" content="index, follow">
	
	<title>Muito Obrigado! | <?= (!is_null($setting) && !empty($setting->getTitle())) ? $setting->getTitle() : 'Kimpages | Agência Mazukim' ?></title>

	<link rel="icon" href="<?= (!is_null($brand) && !empty($brand->getIcon())) ? $brand->getIcon() : ''; ?>" sizes="16x16">
	<?php require("links.php"); ?>

</head>
<body>

	<?php require 'analitycsbody.php'; ?>
	
	<main class="row thanks">
        <figure class="col m6 s12">
            <img src="public/site/images/thank-you.jpg" alt="Muito Obrigado - <?= (!is_null($setting) && !empty($setting->getTitle())) ? $setting->getTitle() : 'Kimpages | Agência Mazukim' ?>">
            <figcaption>Muito Obrigado - <?= (!is_null($setting) && !empty($setting->getTitle())) ? $setting->getTitle() : 'Kimpages | Agência Mazukim' ?></figcaption>
        </figure>
        <article class="col m6 s12">
            <h1>Recebemos Suas Informações</h1>
            <h2>Obrigado por chegar até aqui, você está a um passo de realizar o que deseja!</h2>
			<?php if(!is_null($setting) && !empty($setting->getWhatsapp())): ?>
				<div class="time">
					<h3>10</h3>
					<p>segundos</p>
				</div>
				<p>Aguarde só mais um pouquinho...</p>
				<p>Estamos nos preparando para entrar em contato com você</p>
			<?php endif; ?>
            <?php if(!is_null($social) && !empty($social)): ?>
				<ul>
                    <h4>Vamos nos conectar?</h4>
					<?php if(!empty($social->getFacebook())): ?>
						<li>
							<a href="https://www.facebook.com/<?= $social->getFacebook(); ?>" target="_blank">
								<span class="fab fa-facebook-f"></span>
							</a>
						</li>
					<?php endif; ?>
					<?php if(!empty($social->getInstagram())): ?>
						<li>
							<a href="https://www.instagram.com/<?= $social->getInstagram(); ?>" target="_blank">
								<span class="fab fa-instagram"></span>
							</a>
						</li>
					<?php endif; ?>
					<?php if(!empty($social->getLinkedin())): ?>
						<li>
							<a href="https://www.linkedin.com/<?= $social->getLinkedin(); ?>" target="_blank">
								<span class="fab fa-linkedin-in"></span>
							</a>
						</li>
					<?php endif; ?>
					<?php if(!empty($social->getYoutube())): ?>
						<li>
							<a href="https://www.youtube.com/<?= $social->getYoutube(); ?>" target="_blank">
								<span class="fab fa-youtube"></span>
							</a>
						</li>
					<?php endif; ?>
				</ul>
			<?php endif; ?>
        </article>
		<?php if(!is_null($setting) && !empty($setting->getWhatsapp())): ?>
			<aside>
				<article>
					<figure>
						<img src="public/site/images/time.jpg" alt="">
					</figure>
					<h2>Não Quer Esperar?</h2>
					<p>Fale Conosco Agora. Estamos Online!</p>
					<a href="whatsapp" class="btn waves-effect pulse">
						Chame Agora no Whatsapp
						<strong> <?= $setting->getWhatsapp(); ?> <span class="fab fa-whatsapp"></span></strong>
					</a>
				</article>
			</aside>
		<?php endif; ?>
    </main>

	<?php require 'scripts.php'; ?>
</body>
</html>