<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Configurar Simulador</title>
    <?php require 'links.php'; ?>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="simulator container">
                    <header class="row headline">
                        <a href="" class="action">
                            <span class="fa fa-plus"></span>
                            Adicionar campo
                        </a>
                        <figure>
                            <img src="<?= (!is_null($banner) && !empty($banner->getImage())) ? $banner->getImage() : 'public/site/images/headline.png'; ?>" alt="">
                            <img src="<?= (!is_null($brand) && !empty($brand->getLogo())) ? $brand->getLogo() : 'public/site/images/logo.png'; ?>" alt="<?= (!is_null($setting) && !empty($setting->getTitle())) ? $setting->getTitle() : 'Kimpages | Agência Mazukim' ?>">
                            <figcaption><?= (!is_null($setting) && !empty($setting->getTitle())) ? $setting->getTitle() : 'Kimpages | Agência Mazukim' ?></figcaption>
                        </figure>
                        <fieldset>
                            <form action="" method="post" class="sortable">
                                <?php 
                                    $count = 1;
                                    foreach ($simulator as $item): 
                                        if($item->getType() == 'text'):
                                ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <input type="text" name="step-<?= $count; ?>" placeholder="Escreva aqui" <?= ($item->getRequired() == 1) ? 'required' : ''; ?>>
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php elseif($item->getType() == 'tel'): ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <input type="tel" name="step-<?= $count; ?>" placeholder="Apenas números" <?= ($item->getRequired() == 1) ? 'required' : ''; ?>>
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php elseif($item->getType() == 'email'): ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <input type="email" name="step-<?= $count; ?>" placeholder="exemplo@dominio.com.br" <?= ($item->getRequired() == 1) ? 'required' : ''; ?>>
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php 
                                    elseif($item->getType() == 'select'):
                                    $options = explode(',', $item->getOptions());
                                ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <select name="step-<?= $count; ?>" class="browser-default" <?= ($item->getRequired() == 1) ? 'required' : ''; ?>>
                                                <?php foreach ($options as $value): ?>
                                                    <option value="<?= $value; ?>"><?= $value; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php 
                                    elseif($item->getType() == 'radio'):
                                    $options = explode(',', $item->getOptions());
                                ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <div class="flex">
                                                <?php foreach ($options as $key => $value): ?>
                                                    <p>
                                                        <input id="elem-<?= $key . $count; ?>" name="step-<?= $count; ?>" type="radio" <?= ($item->getRequired() == 1) ? 'required' : ''; ?> value="<?= $value; ?>" />
                                                        <label for="elem-<?= $key . $count; ?>"><?= $value; ?></label>
                                                    </p>
                                                <?php endforeach; ?>
                                            </div>
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php 
                                    elseif($item->getType() == 'checkbox'):
                                    $options = explode(',', $item->getOptions());
                                ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <div class="flex">
                                                <?php foreach ($options as $key => $value): ?>
                                                    <p>
                                                        <input id="check-<?= $key . $count; ?>" name="step-<?= $count; ?>" type="checkbox" <?= ($item->getRequired() == 1) ? 'required' : ''; ?> value="<?= $value; ?>" />
                                                        <label for="check-<?= $key . $count; ?>"><?= $value; ?></label>
                                                    </p>
                                                <?php endforeach; ?>
                                            </div>
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php elseif($item->getType() == 'number'): ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <div class="number">
                                                <input type="number" name="step-<?= $count; ?>" value="<?= $item->getMinQ(); ?>" min="<?= $item->getMinQ(); ?>" max="<?= $item->getMaxQ(); ?>" placeholder="" <?= ($item->getRequired() == 1) ? 'required' : ''; ?>>
                                                <hgroup>
                                                    <button type="button" class="plus"><span class="fa fa-plus"></span></button>
                                                    <button type="button" class="minus"><span class="fa fa-minus"></span></button>
                                                </hgroup>
                                            </div>
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php elseif($item->getType() == 'date'): ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <input type="date" name="step-<?= $count; ?>" <?= ($item->getRequired() == 1) ? 'required' : ''; ?>>
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php elseif($item->getType() == 'money'): ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <input type="tel" name="step-<?= $count; ?>" value="<?= $item->getMinQ(); ?>" class="mask" <?= ($item->getRequired() == 1) ? 'required' : ''; ?>>
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php elseif($item->getType() == 'textarea'): ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <textarea name="step-<?= $count; ?>" placeholder="Comente aqui" <?= ($item->getRequired() == 1) ? 'required' : ''; ?>></textarea>
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php elseif($item->getType() == 'file'): ?>
                                    <label class="steps" id="<?= $item->getId(); ?>">
                                        <button type="button" class="resize"><span class="fa fa-grip-vertical"></span></button>
                                        <hgroup>
                                            <?= $item->getName(); ?>
                                            <input type="file" name="step-<?= $count; ?>" <?= ($item->getRequired() == 1) ? 'required' : ''; ?> />
                                        </hgroup>
                                        <a href="simulator/delete/<?= $item->getId(); ?>" class="delete">
                                            <span class="far fa-trash-alt"></span>
                                        </a>
                                    </label>
                                <?php endif; $count++; endforeach; ?>
                            </form>
                        </fieldset>
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 320"><path fill="#0099ff" fill-opacity="1" d="M0,128L48,117.3C96,107,192,85,288,112C384,139,480,213,576,218.7C672,224,768,160,864,154.7C960,149,1056,203,1152,213.3C1248,224,1344,192,1392,176L1440,160L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path></svg>
                    </header>
                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <aside class="row window campo">
        <fieldset>
            <a href="" class="close">
                <span class="fa fa-times"></span>
            </a>
            <form method="POST" action="simulator/persist">
                <h2>Insira um novo campo</h2>
                <label for="type" class="col s12">
                    Escolha o campo que você deseja:
                    <select name="type" class="browser-default">
                        <option disabled selected value=""><-- Selecione uma das opções --></option>
                        <option value="text">Campo de Texto</option>
                        <option value="tel">Campo de Telefone</option>
                        <option value="email">Campo de E-mail</option>
                        <option value="number">Campo para Quantidade</option>
                        <option value="money">Campo para Dinheiro</option>
                        <option value="date">Campo para Datas</option>
                        <option value="select">Select</option>
                        <option value="radio">Radio</option>
                        <option value="checkbox">Checkbox</option>
                        <option value="textarea">Área de Texto</option>
                        <option value="file">Campo para Arquivos</option>
                    </select>
                </label>
                <div id="content">
                    
                </div>
                <div class="col s12 center">
                    <button type="submit" class="btn waves-effect">Inserir Campo</button>
                </div>
            </form>
        </fieldset>
    </aside>

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>