<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Chamada Serviços</title>
    <?php require 'links.php'; ?>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="service container">
                    <fieldset>
                        <h2>Chamada Serviços</h2>
                        <form method="POST" action="layout/service/persist">
                            <input type="hidden" name="title" value="<?= (!is_null($service) && !empty($service)) ? $service->getTitle() : '' ?>">
                            <input type="hidden" name="subtitle" value="<?= (!is_null($service) && !empty($service)) ? $service->getSubtitle() : '' ?>">
                            <input type="hidden" name="action" value="<?= (!is_null($service) && !empty($service)) ? $service->getAction() : '' ?>">
                            <?php if(!is_null($service) && !empty($service)): ?>
                                <input type="hidden" name="id" value="<?= $service->getId(); ?>">
                                <input type="hidden" name="_method" value="PUT">
                            <?php endif; ?>
                            <section class="row areas center">
                                <h2 contenteditable="true">
                                    <?= (!is_null($service) && !empty($service)) ? $service->getTitle() : 'Insira um titulo' ?>
                                </h2>
                                <h3 contenteditable="true">
                                    <?= (!is_null($service) && !empty($service)) ? $service->getSubtitle() : 'Insira uma descriçao mais completa' ?>
                                </h3>
                                <hr>
                                <a class="col l4 m6 s12">
                                    <article>
                                        <figure>
                                            <img src="public/site/images/form.jpg" alt="">
                                            <figcaption></figcaption>
                                        </figure>
                                        <div class="fundo"></div>
                                        <hgroup>
                                            <h4>Serviço demonstrativo</h4>
                                            <button type="button" class="button" contenteditable="true">
                                                <?= (!is_null($service) && !empty($service)) ? $service->getAction() : 'Insira uma chamada' ?>
                                            </button>
                                        </hgroup>
                                    </article>
                                </a>
                                <a class="col l4 m6 s12">
                                    <article>
                                        <figure>
                                            <img src="public/site/images/empresa.jpg" alt="">
                                            <figcaption></figcaption>
                                        </figure>
                                        <div class="fundo"></div>
                                        <hgroup>
                                            <h4>Serviço demonstrativo</h4>
                                            <button type="button" class="button" contenteditable="true">
                                                <?= (!is_null($service) && !empty($service)) ? $service->getAction() : 'Insira uma chamada' ?>
                                            </button>
                                        </hgroup>
                                    </article>
                                </a>
                                <a class="col l4 m6 s12">
                                    <article>
                                        <figure>
                                            <img src="public/site/images/fundo.png" alt="">
                                            <figcaption></figcaption>
                                        </figure>
                                        <div class="fundo"></div>
                                        <hgroup>
                                            <h4>Serviço demonstrativo</h4>
                                            <button type="button" class="button" contenteditable="true">
                                                <?= (!is_null($service) && !empty($service)) ? $service->getAction() : 'Insira uma chamada' ?>
                                            </button>
                                        </hgroup>
                                    </article>
                                </a>
                            </section>
                            <div class="col s12 center">
                                <button type="submit" class="btn waves-effect">Salvar Alterações</button>
                            </div>
                        </form>
                    </fieldset>

                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <script type="text/javascript" src="public/admin/js/serviceads.js"></script>
    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>