<!DOCTYPE html>
<html lang="en">

<head>
<base href="<?= URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Gerenciador de Qualidade</title>
    <?php require 'links.php'; ?>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="search-data container">
                    <div class="filter">
                        <h2>Motivos Positivos</h2>
                        <button type="button" class="btn waves-effect create" id="0">
                            Criar Motivo
                        </button>
                    </div>
                    <div class="clearfix"></div>
                    <table class="responsive-table">
                        <thead>
                            <tr>
                                <th class="center">ID</th>
                                <th class="center">Descrição</th>
                            </tr>   
                        </thead>
                        <tbody>
                            <?php
                            foreach ($status1 as $item): ?>
                                <tr>
                                    <td class="center"><?= $item->getId(); ?></td>
                                    <td class="center"><?= $item->getName(); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <div class="search-data container">
                    <div class="filter">
                        <h2>Motivos Negativos</h2>
                        <button type="button" class="btn waves-effect create" id="1">
                            Criar Motivo
                        </button>
                    </div>
                    <div class="clearfix"></div>
                    <table class="responsive-table">
                        <thead>
                            <tr>
                                <th class="center">ID</th>
                                <th class="center">Descrição</th>
                            </tr>   
                        </thead>
                        <tbody>
                            <?php
                            foreach ($status2 as $item): ?>
                                <tr>
                                    <td class="center"><?= $item->getId(); ?></td>
                                    <td class="center"><?= $item->getName(); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <aside class="row modalCreate">
        <fieldset>
            <a href="javascript:void(0)" class="close">
                <span class="fa fa-times"></span>
            </a>
            <form method="POST" action="qualidade/create">
                <h2>Criar um Motivo</h2>
                <label for="descricao">
                    <input type="hidden" name="type">
                    <input type="text" name="descricao" required placeholder="Insira aqui...">
                </label>
                <button type="submit" class="btn waves-effect">
                    Cadastrar Motivo
                </button>
            </form>
        </fieldset>
    </aside>

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <script>
        $(document).ready(function () {
            $('.create').click(function(e) {
                e.preventDefault();
                $('.modalCreate').addClass('active');
                $('input[name="type"]').val(this.id);
            });

            $('.modalCreate .close').click(function(e) {
                e.preventDefault();
                $('.modalCreate').removeClass('active');
            });
        });
    </script>
    <?php
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>