<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Redes Sociais</title>
    <?php require 'links.php'; ?>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="midia container">
                    <fieldset>
                        <h2>Redes Sociais</h2>

                        <!-- Formulario para a logo -->
                        <form method="POST" action="social/persist">
                            <p>Preencha os campos abaixo com os dados das Redes Sociais da sua empresa para deixa-las disponíveis em seu site:</p>
                            <?php if(!is_null($social)): ?>
                                <input type="hidden" name="id" value="<?= $social->getId(); ?>">
                                <input type="hidden" name="_method" value="PUT">
                            <?php endif; ?>
                            <div class="flex">
                                <span class="fab fa-facebook-f"></span>
                                <label for="facebook">
                                    Informe abaixo a URL da sua fanpage
                                    <div class="flex">
                                        <span>https://www.facebook.com/</span>
                                        <input type="text" name="facebook" value="<?= (isset($social)) ? $social->getFacebook() : ''; ?>">
                                    </div>
                                </label>
                            </div>
                            <div class="flex">
                                <span class="fab fa-instagram"></span>
                                <label for="instagram">
                                    Informe sua conta no Instagram
                                    <div class="flex">
                                        <span>https://www.instagram.com/</span>
                                        <input type="text" name="instagram" value="<?= (isset($social)) ? $social->getInstagram() : ''; ?>">
                                    </div>
                                </label>
                            </div>
                            <div class="flex">
                                <span class="fab fa-linkedin-in"></span>
                                <label for="linkedin">
                                    Informe abaixo a URL da sua Linkedin Page
                                    <div class="flex">
                                        <span>https://www.linkedin.com/</span>
                                        <input type="text" name="linkedin" value="<?= (isset($social)) ? $social->getLinkedin() : ''; ?>">
                                    </div>
                                </label>
                            </div>
                            <div class="flex">
                                <span class="fab fa-youtube"></span>
                                <label for="youtube">
                                    Informe sua conta no Youtube
                                    <div class="flex">
                                        <span>https://www.youtube.com/</span>
                                        <input type="text" name="youtube" value="<?= (isset($social)) ? $social->getYoutube() : ''; ?>">
                                    </div>
                                </label>
                            </div>
                            <div class="flex">
                                <p>Usar plugin do instagram?</p>
                                <div class="switch">
                                    <label>
                                        Não
                                        <input type="checkbox" name="plugin" <?= (isset($social) && $social->getPlugin() == 1) ? "checked" : ''; ?>>
                                        <span class="lever"></span>
                                        Sim
                                    </label>
                                </div>
                            </div>
                            <div class="center">
                                <button type="submit" class="btn waves-effect">Salvar</button>
                            </div>
                        </form>
                    </fieldset>

                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <script defer src="public/site/js/fontawesome-all.min.js"></script>
    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>