<!DOCTYPE html>
<html lang="en">

<head>
<base href="<?= URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Todos os Leads</title>
    <?php require 'links.php'; ?>
    <link href="public/admin/js/plugins/data-tables/css/jquery.dataTables.min.css" type="text/css" rel="stylesheet" media="screen,projection">

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="search container">
                    <h2 class="flex">
                        Busque Todos os Leads
                        <?php if($type == 0): ?>
                            <a href="" class="btn waves-effect filter">
                                <span class="fa fa-plus"></span>
                                Filtrar seus leads
                            </a>
                        <?php endif; ?>
                    </h2>
                    <?php if($type == 0): ?>
                        <table class="data-table-simple responsive-table display" cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="center">ID</th>
                                    <?php 
                                    $filter = array_filter($filters, function ($elem){
                                        return $elem->getActive() == 1;
                                    });
                                    foreach ($filter as $item): ?>
                                        <th class="center"><?= $item->getName(); ?></th>
                                    <?php endforeach; ?>
                                    <th class="center">Data de Cadastro</th>
                                    <th class="center">Campanha</th>
                                    <th></th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php 
                                    foreach ($leads as $item): 
                                    $answers = explode(',', $item->getAnswers());
                                ?>
                                    <tr>
                                        <td class="center"><?= $item->getId(); ?></td>
                                        <?php 
                                        foreach ($filter as $fill): ?>
                                            <td class="center">
                                                <?php
                                                    foreach ($answers as $value) {
                                                        $divide = explode(' - ', $value);
                                                        if (preg_match("/{$fill->getName()}/i", $divide[0])) {
                                                            echo $divide[1];
                                                        }
                                                    }
                                                ?>
                                            </td>
                                        <?php endforeach; ?>
                                        <td class="center"><?= $item->getDate()->format('d/m/Y H:i'); ?></td>
                                        <td class="center"><?= $item->getCampaign() ?></td>
                                        <td class="center">
                                            <a href="leads/<?= $item->getId() ?>">
                                                <span class="fa fa-eye"></span>
                                            </a>
                                            <a class="delete" href="leads/delete/<?= $item->getId() ?>">
                                                <span class="far fa-trash-alt"></span>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <table class="data-table-simple responsive-table display" cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="center">ID</th>
                                    <th class="center">Nome</th>
                                    <th class="center">Telefone</th>
                                    <th class="center">E-mail</th>
                                    <th class="center">Campanha</th>
                                    <th class="center">Data de Recebimento</th>
                                    <th></th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php 
                                    foreach ($leads as $item): 
                                    $answers = explode(',', $item->getAnswers());
                                ?>
                                    <tr>
                                        <td class="center"><?= $item->getId(); ?></td>
                                        <td class="center">
                                            <?php
                                                foreach ($answers as $value) {
                                                    $divide = explode(' - ', $value);
                                                    if (preg_match("/Nome/", $divide[0])) {
                                                        echo $divide[1];
                                                    }
                                                }
                                            ?>
                                        </td>
                                        <td class="center">
                                            <?php
                                                foreach ($answers as $value) {
                                                    $divide = explode(' - ', $value);
                                                    if (preg_match("/Telefone/", $divide[0])) {
                                                        echo $divide[1];
                                                    }
                                                }
                                            ?>
                                        </td>
                                        <td class="center">
                                            <?php
                                                foreach ($answers as $value) {
                                                    $divide = explode(' - ', $value);
                                                    if (preg_match("/E-mail/", $divide[0])) {
                                                        echo $divide[1];
                                                    }
                                                }
                                            ?>
                                        </td>
                                        <td class="center"><?= $item->getDate()->format('d/m/Y'); ?></td>
                                        <td class="center"><?= $item->getCampaign(); ?></td>
                                        <td class="center">
                                            <a href="leads/<?= $item->getId() ?>">
                                                <span class="fa fa-eye"></span>
                                            </a>
                                            <a class="delete" href="leads/delete/<?= $item->getId() ?>">
                                                <span class="far fa-trash-alt"></span>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <aside class="row window filters">
        <fieldset>
            <a href="" class="close">
                <span class="fa fa-times"></span>
            </a>
            <h2>Escolha como deseja filtrar seus leads</h2>
            <label for="name" class="col s12">
                <hgroup>
                    Criar novo filtro
                    <input type="text" name="name">
                </hgroup>
                <button class="new"><span class="fa fa-plus"></span></button>
            </label>
            <div class="flex">
                <?php foreach ($filters as $key => $value): ?>
                    <p>
                        <strong>
                            <input id="check-<?= $key; ?>" name="filter[]" type="checkbox" <?= ($value->getActive() == 1) ? 'checked' : ''; ?> value="<?= $value->getId(); ?>" />
                            <label for="check-<?= $key; ?>"><?= $value->getName(); ?></label>
                        </strong>
                        <a href="<?= $value->getId(); ?>" class="remove"><span class="far fa-trash-alt"></span></a>
                    </p>
                <?php endforeach; ?>
            </div>
            <div class="col s12 center">
                <a href="leads" class="btn waves-effect">Atualizar Filtros</a>
            </div>
        </fieldset>
    </aside>

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <!-- data-tables -->
    <script type="text/javascript" src="public/admin/js/plugins/data-tables/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="public/admin/js/plugins/data-tables/data-tables-script.js"></script>
    <?php
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>