<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Visualizar Lead</title>
    <?php require 'links.php'; ?>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="cadastro container lead" style="align-items: initial; display: block;">
                    <fieldset class="col m6 s12 push-m3">
                        <h2>Visualizar Lead</h2>
                        <?php 
                            $answers = explode(',', $lead->getAnswers());
                            foreach ($answers as $item):
                                $data = explode(' - ', $item);
                        ?>
                            <div>
                                <h3><?= preg_replace('/_+/', ' ', $data[0]); ?></h3>
                                <p>R: <?= (!empty($data[1])) ? $data[1] : 'Sem resposta' ; ?></p>
                            </div>
                        <?php endforeach; ?>
                        <div>
                            <p>Data de Recebimento: <?= $lead->getDate()->format('d/m/Y'); ?></p>
                            <?php if(!is_null($lead->getPrice())): ?>
                                <p>Valor Gerado: <?= $lead->getPrice(); ?></p>
                            <?php endif; ?>
                            <?php if(!is_null($lead->getCampaign())): ?>
                                <p>Campanha: <?= $lead->getCampaign(); ?></p>
                            <?php endif; ?>
                        </div>
                    </fieldset>
                    <div class="clearfix"></div>
                    <div class="col m6 s12 box history">
                        <h3>
                            Histórico de Registros
                            <button class="btn waves-effect newR">
                                Novo Registro
                                <span class="fa fa-plus"></span>
                            </button>
                        </h3>
                        <ul>
                            <?php foreach ($record as $item): ?>
                                <?php if(!empty($item->getNote())): ?>
                                    <li>
                                        <span class="fa fa-user-edit"></span>
                                        <hgroup>
                                            <datalist>
                                                <time datetime="<?= $item->getDate()->format('d/m/Y'); ?>"><?= $item->getDate()->format('d/m/Y'); ?></time>
                                                <time datetime="<?= $item->getDate()->format('H:i'); ?>"><?= $item->getDate()->format('H:i'); ?></time>
                                            </datalist>
                                            <p><?= $item->getNote(); ?></p>
                                            <cite>Por <strong>Administrador</strong></cite>
                                        </hgroup>
                                    </li>
                                <?php endif; ?>
                                <?php if(!is_null($item->getTransferredSector())): ?>
                                    <li>
                                        <span class="fa fa-dolly"></span>
                                        <hgroup>
                                            <datalist>
                                            <time datetime="<?= $item->getDate()->format('d/m/Y'); ?>"><?= $item->getDate()->format('d/m/Y'); ?></time>
                                                <time datetime="<?= $item->getDate()->format('H:i'); ?>"><?= $item->getDate()->format('H:i'); ?></time>
                                            </datalist>
                                            <p>
                                                Status trocado de 
                                                <?php 
                                                if($item->getCurrentSector() != 0):
                                                    $currentSector = array_filter($status, function ($elem) use ($item){
                                                        return $elem->getId() === $item->getCurrentSector();
                                                    }); 
                                                    $currentSector = current($currentSector);
                                                    
                                                ?>
                                                    <?php if( $currentSector ):?>
                                                        <strong><?= $currentSector->getName(); ?></strong> 
                                                    <?php else: ?>
                                                        <strong>Lead Recebido</strong> 
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <strong>Lead Recebido</strong> 
                                                <?php endif; ?>
                                                para 
                                                <?php 
                                                
                                                $transferredSector = array_filter($status, function ($elem) use ($item){
                                                    return $elem->getId() === $item->getTransferredSector();
                                                }); 
                                                $transferredSector = current($transferredSector);
                                                ?>
                                                <?php if( $transferredSector ):?>
                                                        <strong><?= $transferredSector->getName(); ?></strong> 
        
                                                    <?php endif; ?>
                                            </p>
                                            <cite>Por <strong>Administrador</strong></cite>
                                        </hgroup>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="col m6 s12 box history">
                        <h3>
                            Qualidade do Lead
                            <button class="btn waves-effect newq">
                                Inserir
                                <span class="fa fa-plus"></span>
                            </button>
                        </h3>
                        <ul>
                            <?php foreach ($qualidade as $item):
                            $motivo = array_filter($motivos, function ($elem) use ($item){
                                return $elem->getId() == $item->getQualidade();
                            });
                            $motivo = current($motivo);
                            ?>
                                <?php if($item->getType() == 0): ?>
                                    <li>
                                        <span class="fa fa-bullseye"></span>
                                        <hgroup>
                                            <datalist>
                                                <time datetime="<?= $item->getDate()->format('d/m/Y'); ?>"><?= $item->getDate()->format('d/m/Y'); ?></time>
                                                <time datetime="<?= $item->getDate()->format('H:i'); ?>"><?= $item->getDate()->format('H:i'); ?></time>
                                            </datalist>
                                            <p><strong>Lead Relevante</strong></p>
                                            <p><strong>Motivo:</strong> <?= $motivo ? $motivo->getName() : 'Indefinido'  ?></p>
                                        </hgroup>
                                    </li>
                                <?php endif; ?>
                                <?php if($item->getType() == 1): ?>
                                    <li>
                                        <span class="fa fa-funnel-dollar"></span>
                                        <hgroup>
                                            <datalist>
                                            <time datetime="<?= $item->getDate()->format('d/m/Y'); ?>"><?= $item->getDate()->format('d/m/Y'); ?></time>
                                                <time datetime="<?= $item->getDate()->format('H:i'); ?>"><?= $item->getDate()->format('H:i'); ?></time>
                                            </datalist>
                                            <p><strong>Lead Irrelevante</strong></p>
                                            <p><strong>Motivo:</strong> <?php if($motivo): echo $motivo->getName(); else: echo "indefinido."; endif; ?></p>
                                        </hgroup>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <!-- Modal de Inclusão de Variação -->
    <aside class="row modalRecord">
        <fieldset>
            <button type="button" class="close">
                <span class="fa fa-times"></span>
            </button>
            <h4>Novo Registro</h4>
            <form method="POST" action="record/persist">
                <input type="hidden" name="order" value="<?= $lead->getId(); ?>">
                <?php
                if (!empty($record)):
                    rsort($record); 
                    $record = current($record);
                ?>
                    <input type="hidden" name="status" value="<?= (!is_null($record->getTransferredSector())) ? $record->getTransferredSector() : '0'; ?>">
                <?php else: ?>
                    <input type="hidden" name="status" value="0">
                <?php endif; ?>
                <label for="note">
                    Observação
                    <textarea name="note"></textarea>
                </label>
                <h3>Transferência de Status</h3>
                <label for="transfer" class="col s12 m4">
                    <input type="checkbox" name="transfer" value="1">
                    <span>Trocar para o status</span>
                </label>
                <label for="sector" class="col s12 m4">
                    <select name="sector" class="browser-default"  <?= (!empty($record) && !is_null($record->getTransferredSector())) ? 'style="display: block !important;"' : ''; ?> >
                        <option disabled value="0" <?= ($lead->getStatus() == 0) ? 'selected' : ''; ?>>Lead Recebido</option>
                        <?php foreach ($status as $item):
                            if($item->getId() != 2): ?>
                            <option value="<?= $item->getId(); ?>" <?= ($lead->getStatus() == $item->getId()) ? 'selected' : ''; ?>><?= $item->getName(); ?></option>
                        <?php endif; endforeach; ?>
                    </select>
                </label>
                <label for="price" class="col s12 m4 price" <?= (!is_null($lead->getPrice())) ? 'style="display: block !important;"' : ''; ?>>
                    Valor da Venda
                    <input class="mask" type="text" name="price" value="<?= (!is_null($lead->getPrice())) ? $lead->getPrice() : '';  ?>">
                </label>
                <div class="col s12 center">
                    <button type="submit" class="btn waves-effect">Salvar</button>
                </div>
            </form>
        </fieldset>
    </aside>

    <!-- Modal de Inclusão de Variação -->
    <aside class="row modalRecord q">
        <fieldset>
            <button type="button" class="close">
                <span class="fa fa-times"></span>
            </button>
            <h4>Gerenciador de Qualidade</h4>
            <form method="POST" action="leads/qualidade">
                <input type="hidden" name="lead" value="<?= $lead->getId(); ?>">
                <label for="type" class="col s12">
                    Qual a qualidade do lead?
                    <select name="type" class="browser-default">
                        <option disabled selected>-- Escolha um primeiramente --</option>
                        <option value="0">Lead Relevante</option>
                        <option value="1">Lead Irrelevante</option>
                    </select>
                </label>
                <label for="motivos" class="col s12 disabled">
                    Motivos Positivos
                    <select name="motivos1" class="browser-default">
                        <option disabled selected>-- Escolha um Motivo --</option>
                        <?php 
                        $motivo1 = array_filter($motivos, function ($elem){
                            return $elem->getType() == 0;
                        });
                        foreach ($motivo1 as $item): ?>
                            <option value="<?= $item->getId(); ?>"><?= $item->getName(); ?></option>
                        <?php endforeach; ?>
                    </select>
                </label>
                <label for="motivos" class="col s12 disabled">
                    Motivos Negativo
                    <select name="motivos2" class="browser-default">
                        <option disabled selected>-- Escolha um Motivo --</option>
                        <?php 
                        $motivo1 = array_filter($motivos, function ($elem){
                            return $elem->getType() == 1;
                        });
                        foreach ($motivo1 as $item): ?>
                            <option value="<?= $item->getId(); ?>"><?= $item->getName(); ?></option>
                        <?php endforeach; ?>
                    </select>
                </label>
                <div class="col s12 center">
                    <button type="submit" class="btn waves-effect">Salvar</button>
                </div>
            </form>
        </fieldset>
    </aside>

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>