<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Tags Analitycs</title>
    <?php require 'links.php'; ?>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="cadastro setting container">
                    <fieldset>
                        <h2>Tags Analitycs</h2>
                        <form method="POST" action="google/persist">
                            <?php if(isset($google)): ?>
                                <input type="hidden" name="id" value="<?= $google->getId(); ?>">
                                <input type="hidden" name="_method" value="PUT">
                            <?php endif; ?>
                            <label for="manager" class="col s12">
                                <img src="public/site/images/google-tag.png" alt="">
                                <span>Google Tag Manager</span>
                                <input type="text" name="manager" value="<?= (isset($google)) ? $google->getManager() : ''; ?>" placeholder="Ex: GTM-XXXXXX">
                            </label>
                            <label for="analitycs" class="col s12">
                                <img src="public/site/images/google-analitycs.png" alt="">
                                <span>Google Analitycs</span>
                                <input type="text" name="analitycs" value="<?= (isset($google)) ? $google->getAnalitycs() : ''; ?>" placeholder="Ex: UA-XXXXXXXXX">
                            </label>
                            <label for="facebook" class="col s12">
                                <img src="public/site/images/facebook.png" alt="">
                                <span>Facebook Ads</span>
                                <input type="text" name="facebook" value="<?= (isset($google)) ? $google->getFacebook() : ''; ?>" placeholder="Codigo de verificação de dominio. Apenas o dentro da 'content'">
                            </label>
                            <label for="pixel" class="col s12">
                                <img src="public/site/images/pixel.png" alt="">
                                <span>Pixel Facebook</span>
                                <input type="text" name="pixel" value="<?= (isset($google)) ? $google->getPixel() : ''; ?>" placeholder="Apenas o Pixel ID">
                            </label>
                            <div class="col s12 center">
                                <button type="submit" class="btn waves-effect">Salvar</button>
                            </div>
                        </form>
                    </fieldset>

                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>