<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Upload de Arquivos</title>
    <?php require 'links.php'; ?>
    <!--dropify-->
    <link href="public/admin/js/plugins/dropify/css/dropify.min.css" type="text/css" rel="stylesheet" media="screen,projection">

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="files container">
                    <fieldset class="col m6 s12">
                        <header>
                            <h2>Upload de Arquivos</h2>
                            <a href="#file" class="btn-large waves-effect">
                                <span class="fa fa-upload"></span>
                                Inserir Arquivos
                            </a>
                        </header>
                        <div class="clearfix"></div>
                        <div class="sortable">
                            <?php foreach ($galery as $item): ?>
                                <div class="col s12 m6 l3" id="<?= $item->getId(); ?>">
                                    <div>
                                        <button type="button"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--! Font Awesome Pro 6.0.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2022 Fonticons, Inc. --><path d="M32 176h370.8l-57.38 57.38c-12.5 12.5-12.5 32.75 0 45.25C351.6 284.9 359.8 288 368 288s16.38-3.125 22.62-9.375l112-112c12.5-12.5 12.5-32.75 0-45.25l-112-112c-12.5-12.5-32.75-12.5-45.25 0s-12.5 32.75 0 45.25L402.8 112H32c-17.69 0-32 14.31-32 32S14.31 176 32 176zM480 336H109.3l57.38-57.38c12.5-12.5 12.5-32.75 0-45.25s-32.75-12.5-45.25 0l-112 112c-12.5 12.5-12.5 32.75 0 45.25l112 112C127.6 508.9 135.8 512 144 512s16.38-3.125 22.62-9.375c12.5-12.5 12.5-32.75 0-45.25L109.3 400H480c17.69 0 32-14.31 32-32S497.7 336 480 336z"/></svg></button>
                                        <img src="<?= $item->getImage(); ?>" alt="">
                                        <hgroup>
                                            <p><?= $item->getTitle(); ?></p>
                                            <p><strong>Descrição:</strong> <?= $item->getDescription(); ?></p>
                                        </hgroup>
                                        <hgroup>
                                            <a href="<?= $item->getImage(); ?>" target="_blank" rel="noopener noreferrer">
                                                <span class="fa fa-eye"></span>
                                            </a>
                                            <a href="galery/delete/<?= $item->getId(); ?>" class="delete">
                                                <span class="far fa-trash-alt"></span>
                                            </a>
                                        </hgroup>
                                    </div>
                                </div>
                            <?php endforeach ?>
                        </div>
                    </fieldset>
                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <aside class="window file">
        <fieldset>
            <a href="" class="close">
                <span class="fa fa-times"></span>
            </a>
            <form method="POST" action="galery/persist" enctype="multipart/form-data">
                <label for="title" class="col s12">
                    Coloque um titulo descritivo:
                    <input type="text" name="title" required>
                </label>
                <label for="description" class="col s12">
                    Coloque uma descrição:
                    <input type="text" name="description">
                </label>
                <label for="file" class="col s12">
                    Insira seu arquivo abaixo:
                    <input type="file" id="input-file" name="input-file" class="dropify" required/>
                </label>
                <div class="col s12 center">
                    <button type="submit" class="btn waves-effect">Fazer Upload</button>
                </div>
            </form>
        </fieldset>
    </aside>

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <!-- dropify -->
    <script type="text/javascript" src="public/admin/js/plugins/dropify/js/dropify.min.js"></script>
    <script type="text/javascript" src="public/admin/js/image.js"></script>
    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>