<!DOCTYPE html>

<html lang="en">



<head>

    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">

    <meta charset="utf-8">

	<meta http-equiv="content-language" content="pt-br">

	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<meta http-equiv="content-type" content="text/html; charset=UTF-8">

	<meta http-equiv="cache-control" content="public"/>

	<meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="robots" content="noindex, nofollow">

    

    <title>Login | <?= (!is_null($setting) && !empty($setting->getTitle())) ? $setting->getTitle() : 'Template Suits' ?></title>

    <?php require 'links.php'; ?>

    <link href="public/admin/js/plugins/jquery.nestable/nestable.css" type="text/css" rel="stylesheet" media="screen,projection">



</head>



<body>



    <main class="login">

        <div class="fundo"></div>

        <div class="box">

            <figure>

				<img src="<?= (!is_null($brand) && !empty($brand->getLogo())) ? $brand->getLogo() : 'public/site/images/logo.png'; ?>" class="brand-logo">

				<figcaption>Logo da marca - <?= (!is_null($setting) && !empty($setting->getTitle())) ? $setting->getTitle() : 'Template Suits' ?></figcaption>

			</figure>

            <fieldset>

                <?php if(isset($_SESSION['mensagem'])): ?>

                    <div id="card-alert" class="card <?= ($_SESSION['tipo'] == 'danger') ? 'red' : 'green' ?>">

                        <div class="card-content white-text">

                        <?php if($_SESSION['tipo'] == 'danger'): ?>

                            <p><i class="mdi-alert-error"></i> Erro: <?= $_SESSION['mensagem']; ?></p>

                        <?php else: ?>

                            <p><i class="mdi-navigation-check"></i> Sucesso: <?= $_SESSION['mensagem']; ?></p>

                        <?php endif; ?>

                        </div>

                        <button type="button" class="close white-text" data-dismiss="alert" aria-label="Close">

                            <span aria-hidden="true">×</span>

                        </button>

                    </div>

                <?php

                    unset($_SESSION['tipo']);

                    unset($_SESSION['mensagem']);

                endif;

                ?>
<?php if(isset($token) and !$token): ?>
                <h1>Coloque aqui seu token recebido pelo email.</h1>

                <p>Para recuperar sua senha, coloque o token logo abaixo:</p>
                
                <form method="POST" action="admin/recovery/persist">


                    <input type="text" name="token" placeholder="Insira seu Token aqui" required>

            

                    <button type="submit" class="btn waves-effect" >Enviar</button>

                </form>
                <?php else: ?>
                <h6 class="informer-password" style="display:none; color: red"> Senhas não estão corretas. </h6> 
                    <form method="POST" class="form-persist" action="admin/change/persist">


                <input type="password" name="senha1" id="senha1" placeholder="Coloque sua nova senha." required>

                <input type="password" name="senha2" id="senha2" placeholder="Coloque de novo." required >



<button type="button" class="btn waves-effect" onclick="validarSenha()">Enviar</button>

</form>

                    <?php endif; ?>
            </fieldset>

        </div>

    </main>



    <?php require 'scripts.php'; ?>

    <!--nestable -->

    <link href="public/admin/js/plugins/jquery.nestable/nestable.css" type="text/css" rel="stylesheet" media="screen,projection">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.14/dist/sweetalert2.all.min.js"></script>

<script>
$(document).ready(function() {
let senha1 = document.getElementById('senha1');
let senha2 = document.getElementById('senha2');
let informer = document.querySelector('.informer-password');

senha1.addEventListener ('keyup', (event) => {
    if(senha1.value != '' && senha2.value != '') { 
    if(senha2.value != senha1.value) {
        senha1.setAttribute('style', 'border: 1px solid red !important');
	    senha2.setAttribute('style', 'border: 1px solid red !important');
        informer.style.display = "initial";
    }
    else if(senha1.value == senha1.value) { 
        senha1.setAttribute('style', 'border: 1px solid black !important');
        senha2.setAttribute('style', 'border: 1px solid black !important');
        informer.style.display = "none";
} 
}
});

senha2.addEventListener ('keyup', (event) => {
    if(senha1.value != '' && senha2.value != '') { 
    if(senha2.value != senha1.value) {
        senha1.setAttribute('style', 'border: 1px solid red !important');
	    senha2.setAttribute('style', 'border: 1px solid red !important');
        informer.style.display = "initial";
    }
    else if(senha2.value == senha1.value) { 
        senha1.setAttribute('style', 'border: 1px solid black !important');
        senha2.setAttribute('style', 'border: 1px solid black !important');
        informer.style.display = "none";
} 
}
});
})

function validarSenha()
{
    let s1 = senha1.value;
    let s2 = senha2.value;
    let form = document.querySelector('.form-persist');
    if (s1 != "" && s2 != "" && s1 === s2)
    {
        Swal.fire({
  icon: 'success',
  title: 'As senhas conferem. Sua senha está sendo modificada...',
  showConfirmButton: false,
  timer: 2000
}).then(() => form.submit());
    }
    else
    {
        swal.fire('Senhas não conferem. Escreva corretamente.');
    }
}


</script>

</body>




</html>