<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Gerenciador de Serviço</title>
    <?php require 'links.php'; ?>
    <!--dropify-->
    <link href="public/admin/js/plugins/dropify/css/dropify.min.css" type="text/css" rel="stylesheet" media="screen,projection">
    <script src="public/admin/ckeditor/ckeditor.js"></script>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="cadastro">
                    <fieldset class="full">
                        <h2>Gerenciador de Serviço</h2>
                        <form method="POST" action="service/persist" enctype="multipart/form-data">
                        <?php if(isset($service)): ?>
                            <input type="hidden" name="id" value="<?= $service->getId(); ?>">
                            <input type="hidden" name="_method" value="PUT">
                        <?php endif; ?>
                            <div class="col m6 s12">
                                <label for="title">
                                    Qual será o nome do serviço?
                                    <input type="text" name="title" value="<?= (isset($service)) ? $service->getTitle() : ''; ?>">
                                </label>
                                <div class="center">
                                    <label for="description">Escreva uma descrição para o serviço</label>
                                    <textarea name="description" class="editor" required>
                                        <?= (isset($service)) ? $service->getDescription() : '<p>Insira uma observação<p/>'; ?>
                                    </textarea>
                                </div>
                            </div>
                            <div class="col s12 m6 serviceSwitch">
                                <?php 
                                    $videoChecked = isset($service) && strpos($service->getImage(), 'public/') !== 0 ? 'checked' : '';
                                ?>
                                <div class="col s12 center">
                                    <div class="col s12 switch-flex">
                                        <h3>Mídia do Serviço</h3>
                                        <div class="switch">
                                            <span>Inserir Vídeo</span>
                                            <label>
                                                <input type="checkbox" name="video_enabled" <?= $videoChecked; ?>>
                                                <span class="lever"></span> 
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col s12">
                                     <?php if(!isset($service) || empty($service->getImage())): ?>
                                        <div class="flex youtube-section">
                                            <span class="fab fa-youtube"></span>
                                            <label for="youtube">
                                                Informe o link do vídeo
                                                <div class="flex">
                                                    <span>https://www.youtube.com/watch?</span>
                                                    <input type="text" name="youtube" value="<?= (isset($service)) ? $service->getImage() : ''; ?>">
                                                </div>
                                            </label>
                                        </div>
                                        <figure class="col s12 dropify-section">
                                                <input type="file" id="input-file" name="input-file" class="dropify" />                                         
                                        </figure>
                                    <?php else: ?>
                                        <?php if(strpos($service->getImage(), 'public/')=== false): ?>
                                            <div class="flex youtube-section">
                                                <div class="col s12">
                                                    <span class="fab fa-youtube"></span>
                                                    <label for="youtube">
                                                        Informe o link do vídeo
                                                        <div class="flex">
                                                            <span>https://www.youtube.com/watch?</span>
                                                            <input type="text" name="youtube" value="<?= (isset($service)) ? $service->getImage() : ''; ?>">
                                                        </div>
                                                    
                                                    
                                                    </label>
                                                </div>
                                               
                                                <div class="clearfix"></div>
                                                <div class="col s12">
                                                    <iframe width="100%" height="315" 
                                                        src="https://www.youtube.com/embed/<?= $service->getImage(); ?>" 
                                                        title="<?= $service->getTitle(); ?>" 
                                                        frameborder="0" 
                                                        allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                                                        allowfullscreen>
                                                    </iframe>
                                                </div>
                                            </div>
                                            <figure class="col s12 dropify-section">
                                                <input type="file" id="input-file" name="input-file" class="dropify" />     
                                            </figure>
                                        <?php else: ?>
                                            <figure class="col s12 dropify-section">
                                                <input type="file" id="input-file" name="input-file" class="dropify" data-default-file="<?= $service->getImage(); ?>" />
                                            </figure>
                                            <div class="flex youtube-section">
                                                <span class="fab fa-youtube"></span>
                                                <label for="youtube">
                                                    Informe o link do vídeo
                                                    <div class="flex">
                                                        <span>https://www.youtube.com/watch?</span>
                                                        <input type="text" name="youtube" value="">
                                                    </div>
                                                </label>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col s12 center">
                                <button type="submit" class="btn waves-effect">Salvar</button>
                            </div>
                        </form>
                    </fieldset>
                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <!-- dropify -->
    <script type="text/javascript" src="public/admin/js/plugins/dropify/js/dropify.min.js"></script>
    <script type="text/javascript" src="public/admin/js/service.js"></script>
  
    <script>
  document.addEventListener("DOMContentLoaded", function() {
    // Seleciona o checkbox (switch)
    const switchInput = document.querySelector('input[name="video_enabled"]');
    
    // Seleciona as seções que serão exibidas ou ocultadas
    const youtubeSection = document.querySelector('.youtube-section'); // Seção do YouTube
    const dropifySection = document.querySelector('.dropify-section'); // Seção do Dropify

    // Função para atualizar a visibilidade com base no estado do switch
    function toggleSections() {
        if (switchInput.checked) {
            // Exibe a seção do YouTube
            youtubeSection.style.visibility = 'visible';
            youtubeSection.style.opacity = '1';
            youtubeSection.style.height = 'auto';
            
            // Oculta a seção do Dropify
            dropifySection.style.visibility = 'hidden';
            dropifySection.style.opacity = '0';
            dropifySection.style.height = '0';
        } else {
            // Exibe a seção do Dropify
            dropifySection.style.visibility = 'visible';
            dropifySection.style.opacity = '1';
            dropifySection.style.height = 'auto';

            // Oculta a seção do YouTube
            youtubeSection.style.visibility = 'hidden';
            youtubeSection.style.opacity = '0';
            youtubeSection.style.height = '0';
        }
    }

    // Chama a função para definir o estado inicial
    toggleSections();

    // Adiciona o evento de mudança no checkbox (switch)
    switchInput.addEventListener('change', toggleSections);
});

</script>


</script>

    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>