<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Perguntas Frequentes</title>
    <?php require 'links.php'; ?>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="cadastro container">
                    <fieldset>
                        <h2>Perguntas Frequentes</h2>
                        <form method="POST" action="questions/persist">
                            <?php if(isset($questions)): ?>
                                <input type="hidden" name="id" value="<?= $questions->getId(); ?>">
                                <input type="hidden" name="_method" value="PUT">
                            <?php endif; ?>
                            <label for="question" class="col s12">
                                Insira a pergunta:
                                <input type="text" name="question" value="<?= (isset($questions)) ? $questions->getQuestion() : ''; ?>">
                            </label>
                            <div class="col s12 center">
                                <label for="answer">Resposta para a pergunta</label>
                                <textarea name="answer" class="answer" required>
                                    <?= (isset($questions)) ? $questions->getAnswer() : ''; ?>
                                </textarea>
                                <button type="submit" class="btn waves-effect">Salvar</button>
                            </div>
                        </form>
                    </fieldset>

                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <script src="public/admin/ckeditor/ckeditor.js"></script>
    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>