<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Alterar cor do tema</title>
    <?php require 'links.php'; ?>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="logo container">
                    <fieldset>
                        <h2>Alterar cor do tema</h2>

                        <!-- Formulario para a logo -->
                        <form method="POST" action="color/persist">
                            <h3>Cor do tema</h3>
                            <p>Escolha a cor do tema apartir da paleta de cores que aparece com o clique na caixa abaixo:</p>
                            <div id="card-alert" class="card orange">
                                <div class="card-content white-text">
                                    <p><i class="mdi-action-info-outline"></i> Lembrete: Trabalhe com cores fortes, para aparecer de forma clara todas as informações do site.</p>
                                </div>
                                <button type="button" class="close white-text" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                            </div>
                            <?php if(!is_null($color)): ?>
                                <input type="hidden" name="id" value="<?= $color->getId(); ?>">
                                <input type="hidden" name="_method" value="PUT">
                            <?php endif; ?>
                            <div class="color">
                                <hgroup>
                                    <p>Cor Primária</p>
                                    <input type="color" name="primary" value="<?= (!is_null($color) && !empty($color->getColorFirst())) ? $color->getColorFirst() : ''; ?>">
                                </hgroup>
                                <hgroup>
                                    <p>Cor Secundária</p>
                                    <input type="color" name="secondary" value="<?= (!is_null($color) && !empty($color->getColorSecond())) ? $color->getColorSecond() : ''; ?>">
                                </hgroup>
                            </div>
                            <div class="col s12 center">
                                <?php if(!is_null($color) && !empty($color->getColorFirst())): ?>
                                    <a href="color/delete" class="btn waves-effect">
                                        <span class="far fa-trash-alt"></span>
                                        Resetar Cor
                                    </a>
                                <?php endif; ?>
                                <button type="submit" class="btn waves-effect">
                                    <span class="far fa-check-circle"></span>
                                    Alterar Cor
                                </button>
                            </div>
                        </form>
                    </fieldset>

                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>