<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Chamada Contato</title>
    <?php require 'links.php'; ?>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="contact container">
                    <fieldset>
                        <h2>Chamada Contato</h2>
                        <form method="POST" action="layout/contact/persist" enctype="multipart/form-data">
                            <input type="hidden" name="title" value="<?= (!is_null($contact) && !empty($contact)) ? $contact->getTitle() : '' ?>">
                            <input type="hidden" name="subtitle" value="<?= (!is_null($contact) && !empty($contact)) ? $contact->getSubtitle() : '' ?>">
                            <input type="hidden" name="action" value="<?= (!is_null($contact) && !empty($contact)) ? $contact->getAction() : '' ?>">
                            <?php if(!is_null($contact) && !empty($contact)): ?>
                                <input type="hidden" name="id" value="<?= $contact->getId(); ?>">
                                <input type="hidden" name="_method" value="PUT">
                            <?php endif; ?>
                            <header class="row form center">
                                <div class="file-field input-field">
                                    <div class="btn">
                                        <span><i class="mdi-action-perm-media"></i></span>
                                        <input type="file" name="image">
                                    </div>
                                </div>
                                <?php if(is_null($contact) && empty($contact)): ?>
                                    <figure>
                                        <img src="public/site/images/form.jpg" alt="">
                                        <figcaption></figcaption>
                                    </figure>
                                <?php else: ?>
                                    <figure>
                                        <img src="<?= $contact->getImage(); ?>" alt="">
                                        <figcaption></figcaption>
                                    </figure>
                                <?php endif; ?>
                                <div class="content">
                                    <h3 contentEditable="true">
                                        <?= (!is_null($contact) && !empty($contact->getTitle())) ? $contact->getTitle() : 'Titulo da Página' ?> 
                                    </h3>
                                    <h2 contentEditable="true">
                                        <?= (!is_null($contact) && !empty($contact->getSubtitle())) ? $contact->getSubtitle() : 'Insira um titulo chamativo' ?>
                                    </h2>
                                    <div class="form">
                                        <div class="col m6 s12">
                                            <input type="text" name="name" disabled
                                            placeholder="Nome*">
                                        </div>
                                        <div class="col m6 s12">
                                            <input type="tel" name="phone" disabled
                                            placeholder="Telefone*">
                                        </div>
                                        <div class="col s12">
                                            <input type="email" name="email" disabled
                                            placeholder="E-mail*">
                                        </div>
                                        <div class="col s12">
                                            <textarea class="materialize-textarea" name="mensage" disabled
                                            placeholder="Mensagem*"></textarea>
                                        </div>
                                        <a class="btn-large waves-effect" contentEditable="true">
                                            <?= (!is_null($contact) && !empty($contact->getAction())) ? $contact->getAction() : 'Insira sua chamada' ?>
                                        </a>
                                    </div>
                                </div>
                            </header>
                            <div class="col s12 center">
                                <button type="submit" class="btn waves-effect">Salvar Alterações</button>
                            </div>
                        </form>
                    </fieldset>

                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <script type="text/javascript" src="public/admin/js/contact.js"></script>
    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>