<!DOCTYPE html>

<html lang="en">



<head>

    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">

    <meta charset="utf-8">

	<meta http-equiv="content-language" content="pt-br">

	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<meta http-equiv="content-type" content="text/html; charset=UTF-8">

	<meta http-equiv="cache-control" content="public"/>

	<meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="robots" content="noindex, nofollow">

    

    <title>Configurações Gerais</title>

    <?php require 'links.php'; ?>



</head>



<body>



    <?php require 'header.php'; ?>



    <!-- START MAIN -->

    <div id="main">

        <!-- START WRAPPER -->

        <div class="wrapper">

            <?php require 'menu.php' ?>

            <!-- START CONTENT -->

            <section class="row" id="content">

                <!--start container-->

                <div class="cadastro setting container">

                    <fieldset>

                        <h2>Configurações Gerais</h2>

                        <form method="POST" action="setting/persist">

                            <?php if(isset($setting)): ?>

                                <input type="hidden" name="id" value="<?= $setting->getId(); ?>">

                                <input type="hidden" name="_method" value="PUT">

                            <?php endif; ?>

                            <label for="title" class="col s12">

                                <span>Titulo do Site</span>

                                <input type="text" name="title" value="<?= (isset($setting)) ? $setting->getTitle() : ''; ?>" placeholder="Template Suits" required>

                            </label>

                            <!-- <label for="url" class="col s12">

                                <span>URL do Site</span>

                                <input type="text" name="url" value="<?= (isset($setting)) ? $setting->getUrl() : ''; ?>" placeholder="https://www.suits.mazukim.com.br/">

                            </label> -->

                            <label for="email" class="col s12">

                                <span>E-mail de Recebimento</span>

                                <input type="email" name="email" value="<?= (isset($setting)) ? $setting->getEmail() : ''; ?>" placeholder="contato@mazukim.com.br" required>

                            </label>

                            <!-- <label for="phone" class="col s12">

                                <span>Telefone</span>

                                <input type="tel" name="phone" value="<?= (isset($setting)) ? $setting->getPhone() : ''; ?>" placeholder="(11) 3547-4953">

                            </label> -->

                            <label for="whatsapp" class="col s12">

                                <span>WhatsApp</span>

                                <input type="tel" name="whatsapp" value="<?= (isset($setting)) ? $setting->getWhatsapp() : ''; ?>" placeholder="(11) 91111-1111">

                            </label>


                            <label for="cnpj" class="col s12">

                                    <span>CPNJ</span>

                                    <input type="tel" name="cnpj" value="<?= (isset($setting)) ? $setting->getCnpj() : ''; ?>" placeholder="XX. XXX. XXX/0001-XX.">

                            </label>
                            <label for="helpkim" class="col s12">

                                <span>Id Helpkim</span>

                                <input type="text" name="helpkim" value="<?= (isset($setting)) ? $setting->getIdHelpkim() : ''; ?>">

                            </label>

      
                            <label for="label" class="col s12">

                                <span>Gestão de Leads</span>

                                <div class="switch">
                                    <label style="color:gray;font-size:13px;font-weight:400;">
                                        Não
                                        <input type="checkbox" onclick="checkedSwitch()" class="switch-checkbox" name="plugin" <?php if(isset($setting) and !is_null($setting->getLead()) and $setting->getLead() == 1):  ?>  checked  <?php  endif; ?>>
                                        <span class="lever" style="margin-right: 17px !important;"></span>
                                        Sim
                                    </label>
                                </div>                               

                            </label>



                            
                            <div class="col s12 center">
                            <a href="admin/forgot" style="    color: midnightblue;font-weight: bold;">  Esqueci o Login e/ou a Senha</a>
                            </div>


                            <!-- <label for="address" class="col s12">

                                <span>Endereço Fisíco</span>

                                <input type="text" name="address" value="<?= (isset($setting)) ? $setting->getAddress() : ''; ?>" placeholder="Rua Mazukim, Nº 101 - Parque Suits">

                            </label>

                            <label for="iframe" class="col s12">

                                <span>Iframe do Google Maps</span>

                                <input type="text" name="iframe" value="<?= (isset($setting)) ? $setting->getIframe() : ''; ?>">

                            </label> -->

                            <div class="col s12 center">

                                <button type="submit" class="btn waves-effect">Salvar</button>

                            </div>

                        </form>

                    </fieldset>



                </div>

                <!--end container-->

            </section>

            <!-- END CONTENT -->

        </div>

        <!-- END WRAPPER -->

    </div>

    <!-- END MAIN -->



    <?php require 'footer.php'; ?>

    <?php require 'scripts.php'; ?>


    <script>

function checkedSwitch(){ 
        let menuLead = document.querySelector('.menu-lead');
        let checked = document.querySelector('.switch-checkbox');
        let url = '<?=URL_BASE?>/setting/onlylead';        

        if(!checked.checked){
            checked.setAttribute('checked','false');
            menuLead.style.display = "none";
            let lead = 0;
            $.post(url, `lead=${lead}`).done(function (json) {
 console.log(json);
}, 'json');}
        else  {
            checked.setAttribute('checked','checked');
            menuLead.style.display = "initial";
            let lead = 1;
            $.post(url, `lead=${lead}`);  
        }


    }
</script>

    <?php    

    if(isset($_SESSION['mensagem'])): ?>

    <script>

        swal({

                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",

                text: "<?= $_SESSION['mensagem']; ?>",   

                type: "<?= $_SESSION['tipo']; ?>",   

                showCancelButton: false,   

                confirmButtonColor: "#77dd77",   

                confirmButtonText: "Tudo bem!",   

                closeOnConfirm: true

              });

    </script>

    <?php

        unset($_SESSION['tipo']);

        unset($_SESSION['mensagem']);

    endif;

    ?>

    

</body>



</html>