<!DOCTYPE html>
<html lang="en">

<head>
    <base href="<?= (!is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE; ?>">
    <meta charset="utf-8">
	<meta http-equiv="content-language" content="pt-br">
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta http-equiv="content-type" content="text/html; charset=UTF-8">
	<meta http-equiv="cache-control" content="public"/>
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex, nofollow">
    
    <title>Chamada Principal</title>
    <?php require 'links.php'; ?>

</head>

<body>

    <?php require 'header.php'; ?>

    <!-- START MAIN -->
    <div id="main">
        <!-- START WRAPPER -->
        <div class="wrapper">
            <?php require 'menu.php' ?>
            <!-- START CONTENT -->
            <section class="row" id="content">
                <!--start container-->
                <div class="banner container">
                    <fieldset>
                        <h2>Chamada Principal</h2>
                        <form method="POST" action="layout/banner/persist" enctype="multipart/form-data">
                            <input type="hidden" name="title" value="<?= (!is_null($banner) && !empty($banner)) ? $banner->getTitle() : '' ?>">
                            <input type="hidden" name="description" value="<?= (!is_null($banner) && !empty($banner)) ? $banner->getDescription() : '' ?>">
                            <?php if(!is_null($banner) && !empty($banner)): ?>
                                <input type="hidden" name="id" value="<?= $banner->getId(); ?>">
                                <input type="hidden" name="_method" value="PUT">
                            <?php endif; ?>
                            <header class="row head center">
                                <div class="file-field input-field">
                                    <div class="btn">
                                        <span><i class="mdi-action-perm-media"></i></span>
                                        <input type="file" name="banner">
                                    </div>
                                </div>
                                <?php if(is_null($banner) && empty($banner)): ?>
                                    <figure>
                                        <img src="public/site/images/headline.png" alt="">
                                        <figcaption></figcaption>
                                    </figure>
                                <?php else: ?>
                                    <figure>
                                        <img src="<?= $banner->getImage(); ?>" alt="">
                                        <figcaption></figcaption>
                                    </figure>
                                <?php endif; ?>
                                <div class="edition">
                                    <h1 contentEditable="true">
                                        <?= (!is_null($banner) && !empty($banner->getTitle())) ? $banner->getTitle() : 'Insira um Título Aqui' ?>
                                    </h1>
                                    <p contentEditable="true">
                                        <?= (!is_null($banner) && !empty($banner->getDescription())) ? $banner->getDescription() : 'Coloque uma descrição, para chamar mais atenção ao seu titulo' ?>
                                    </p>
                                </div>
                            </header>
                            <div class="col s12 center">
                                <button type="submit" class="btn waves-effect">Salvar Alterações</button>
                            </div>
                        </form>
                    </fieldset>

                </div>
                <!--end container-->
            </section>
            <!-- END CONTENT -->
        </div>
        <!-- END WRAPPER -->
    </div>
    <!-- END MAIN -->

    <?php require 'footer.php'; ?>
    <?php require 'scripts.php'; ?>
    <script type="text/javascript" src="public/admin/js/banner.js"></script>
    <?php    
    if(isset($_SESSION['mensagem'])): ?>
    <script>
        swal({
                title: "<?= ($_SESSION['tipo'] == 'success') ? 'Tudo Certo!' : 'Ooops tem um erro!'; ?>",
                text: "<?= $_SESSION['mensagem']; ?>",   
                type: "<?= $_SESSION['tipo']; ?>",   
                showCancelButton: false,   
                confirmButtonColor: "#77dd77",   
                confirmButtonText: "Tudo bem!",   
                closeOnConfirm: true
              });
    </script>
    <?php
        unset($_SESSION['tipo']);
        unset($_SESSION['mensagem']);
    endif;
    ?>
    
</body>

</html>