<?php

namespace Template\Entity;

/**
 * @Entity
 * @Table(name="social")
 */
class Social
{
    /**
     * @Id
     * @GeneratedValue
     * @Column(type="integer")
     */
    private $id;
    /**
     * @Column(type="string")
     */
    private $facebook;
    /**
     * @Column(type="string")
     */
    private $instagram;
    /**
     * @Column(type="string")
     */
    private $linkedin;
    /**
     * @Column(type="string")
     */
    private $youtube;
    /**
     * @Column(type="integer", nullable=true)
     */
    private $plugin;

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getFacebook(): string
    {
        return $this->facebook;
    }

    public function setFacebook(string $facebook): self
    {
        $this->facebook = $facebook;

        return $this;
    }

    public function getInstagram(): string
    {
        return $this->instagram;
    }

    public function setInstagram(string $instagram): self
    {
        $this->instagram = $instagram;

        return $this;
    }

    public function getLinkedin(): string
    {
        return $this->linkedin;
    }

    public function setLinkedin(string $linkedin): self
    {
        $this->linkedin = $linkedin;

        return $this;
    }
 
    public function getYoutube(): string
    {
        return $this->youtube;
    }

    public function setYoutube(string $youtube): self
    {
        $this->youtube = $youtube;

        return $this;
    }

    public function getPlugin(): ?int
    {
        return $this->plugin;
    }

    public function setPlugin(int $plugin): self
    {
        $this->plugin = $plugin;

        return $this;
    }
}
