<?php

namespace Template\Entity;

/**
 * @Entity
 * @Table(name="simulator")
 */
class Simulator
{
    /**
     * @Id
     * @GeneratedValue
     * @Column(type="integer")
     */
    private $id;
    /** 
     * @Column(type="string") 
     **/
    private $type;
    /** 
     * @Column(type="string") 
     **/
    private $name;
    /** 
     * @Column(type="integer") 
     **/
    private $required;
    /** 
     * @Column(type="string", length=10000, nullable=true)
     **/
    private $options;
    /** 
     * @Column(type="integer", nullable=true) 
     **/
    private $minQ;
    /** 
     * @Column(type="integer", nullable=true) 
     **/
    private $maxQ;
    /** 
     * @Column(type="integer", nullable=true) 
     **/
    private $maxLength;
    /** 
     * @Column(type="integer", nullable=true) 
     **/
    private $position;

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getRequired(): int
    {
        return $this->required;
    }

    public function setRequired(int $required): self
    {
        $this->required = $required;

        return $this;
    }

    public function getOptions(): ?string
    {
        return $this->options;
    }

    public function setOptions(string $options): self
    {
        $this->options = $options;

        return $this;
    }

    public function getMinQ(): ?int
    {
        return $this->minQ;
    }

    public function setMinQ(int $minQ): self
    {
        $this->minQ = $minQ;

        return $this;
    }

    public function getMaxQ(): ?int
    {
        return $this->maxQ;
    }

    public function setMaxQ(int $maxQ): self
    {
        $this->maxQ = $maxQ;

        return $this;
    }

    public function getMaxLength(): ?int
    {
        return $this->maxLength;
    }

    public function setMaxLength(int $maxLength): self
    {
        $this->maxLength = $maxLength;

        return $this;
    }

    public function getPosition(): int
    {
        return $this->position;
    }

    public function setPosition(int $position): self
    {
        $this->position = $position;

        return $this;
    }
}
