<?php

namespace Template\Entity;

/**
 * @Entity
 * @Table(name="leads")
 */
class Leads
{
    /**
     * @Id
     * @GeneratedValue
     * @Column(type="integer")
     */
    private $id;
    /**
     * @Column(type="text")
     */
    private $answers;
    /**
     * @Column(type="string")
     */
    private $origin;
    /**
     * @Column(type="string")
     */
    private $url;
    /**
     * @Column(type="string")
     */
    private $code;
    /**
     * @Column(type="datetime")
     */
    private $date;
    /**
     * @Column(type="integer")
     */
    private $status;
    /**
     * @Column(type="string", nullable=true)
     */
    private $price;
    /**
     * @Column(type="integer")
     */
    private $type;
      /**
     * @Column(type="string", nullable=true)
     */
    private $campaign;

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getDate(): \DateTime
    {
        return $this->date;
    }

    public function setDate(): self
    {
        $this->date = new \DateTime("now");
        return $this;
    }

    public function getAnswers(): string
    {
        return $this->answers;
    }

    public function setAnswers(string $answers): self
    {
        $this->answers = $answers;

        return $this;
    }

    public function getOrigin(): string
    {
        return $this->origin;
    }

    public function setOrigin(string $origin): self
    {
        $this->origin = $origin;

        return $this;
    }

    public function getUrl(): string
    {
        return $this->url;
    }

    public function setUrl(string $url): self
    {
        $this->url = $url;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->code = $code;

        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(string $price): self
    {
        $this->price = $price;

        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $type): self
    {
        $this->type = $type;

        return $this;
    }
    
    public function getCampaign(): ?string
    {
        return $this->campaign;
    }

    public function setCampaign(string $campaign): self
    {
        $this->campaign = $campaign;

        return $this;
    }
}
