<?php

namespace Template\Entity;

/**
 * @Entity
 * @Table(name="bond")
 */
class Bond
{
    /**
     * @Id
     * @GeneratedValue
     * @Column(type="integer")
     */
    private $id;
    /**
     * @Column(type="integer")
     */
    private $lead;
    /**
     * @Column(type="integer")
     */
    private $type;
    /**
     * @Column(type="integer")
     */
    private $qualidade;
    /**
     * @Column(type="datetime")
     */
    private $date;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getDate()
    {
        return $this->date;
    }

    public function setDate()
    {
        $this->date = new \DateTime("now");
        return $this;
    }

    public function getLead(): int
    {
        return $this->lead;
    }

    public function setLead(int $lead): self
    {
        $this->lead = $lead;

        return $this;
    }

    public function getType(): int
    {
        return $this->type;
    }

    public function setType(int $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getQualidade(): int
    {
        return $this->qualidade;
    }

    public function setQualidade(int $qualidade): self
    {
        $this->qualidade = $qualidade;

        return $this;
    }
}
