<?php

namespace Template\Controller;

use League\Plates\Engine;
use Template\Entity\Color;
use Template\Entity\Config;
use Template\Entity\Google;
use Template\Entity\Service;
use CoffeeCode\Router\Router;
use Template\Helper\FlashMessageTrait;
use Doctrine\ORM\EntityManagerInterface;

class Send 
{

    use FlashMessageTrait;

    private $view;
    private $repositorioService;
    private $repositorioSetting;
    private $repositorioColor;
    private $repositorioAnalitycs;
    private $router;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->view = new Engine(__DIR__ . '/../../views/site/');
        $this->repositorioService = $entityManager
            ->getRepository(Service::class);
        $this->repositorioSetting = $entityManager
            ->getRepository(Config::class);
        $this->repositorioColor = $entityManager
            ->getRepository(Color::class);
        $this->repositorioAnalitycs = $entityManager->getRepository(Google::class);
        $this->router = new Router(URL_BASE);
    }

    public function simulator($data)
    {
        $service = $this->repositorioService->find($data['service']);
        $config =  $this->repositorioSetting->findOneBy(['id' => 1]);
        $headers =  'MIME-Version: 1.0' . "\r\n"; 
        $headers .= "From: {$config->getTitle()} <{$config->getEmail()}>" . "\r\n";
        $headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
        
        $mensagem = $this->view->render('email', [
            'config' => $config,
            'data' => $data,
            'color' => $this->repositorioColor->findOneBy(['id' => 1]),
            'service' => $service->getTitle(),
            'google' => $this->repositorioAnalitycs->findOneBy(['id' => 1])
        ]);
        
        try {
            mail($config->getEmail(), "Simulação", $mensagem, $headers);
            mail("marketing@mazukim.com.br", "Simulação - {$config->getTitle()} ", $mensagem, $headers);
        } catch (\Throwable $th) {
            echo $th->getMessage();
        }
    }

    public function contact($data)
    {
        $config =  $this->repositorioSetting->findOneBy(['id' => 1]);
        
        $headers =  'MIME-Version: 1.0' . "\r\n"; 
        $headers .= "From: {$config->getTitle()} <{$config->getEmail()}>" . "\r\n";
        $headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";

        $mensagem = $this->view->render('email', [
            'config' => $config,
            'color' => $this->repositorioColor->findOneBy(['id' => 1]),
            'data' => $data,
            'google' => $this->repositorioAnalitycs->findOneBy(['id' => 1])
        ]);
        
        try {
            mail($config->getEmail(), "Contato do cliente", $mensagem, $headers);
            mail("marketing@mazukim.com.br", "Contato do cliente - {$config->getTitle()} ", $mensagem, $headers);
            $this->defineMensagem('success', "Sua mensagem foi enviada com sucesso para um dos nossos moderadores, assim que possível, estaremos entrando em contato para mais detalhes.");
            echo "<script>history.go(-1);</script>";
        } catch (\Throwable $th) {
            $this->defineMensagem('error', "{$th->getMessage()}");
            echo "<script>history.go(-1);</script>";
        }
    }
    
}
