<?php

namespace Template\Controller;

use League\Plates\Engine;
use CoffeeCode\Router\Router;
use Doctrine\ORM\EntityManagerInterface;
use Template\Entity\Brand;
use Template\Entity\Config;
use Template\Services\Mailer;
use Template\Helper\FlashMessageTrait;

class Denuncia 
{

    use FlashMessageTrait;

    private $view;
    private $mailView;
    private $router;
    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->view = new Engine(__DIR__ . '/../../views/admin/');
        $this->mailView = new Engine(__DIR__ . '/../../views/emails/');
        $this->router = new Router(URL_BASE);
        $this->repositoryBrand = $entityManager->getRepository(Brand::class);
        $this->repositoryConfig = $entityManager->getRepository(Config::class);

    }

    public function index()
    { 
        echo $this->view->render('denuncia',[

            'brand' => $this->repositoryBrand->findOneBy(['id' => 1]),

            'setting' => $this->repositoryConfig->findOneBy(['id' => 1])

            ]);
    }


/**   
                $view =   strval($this->mailView->render('denuncia-email',[
                                'name' => $data['name'],
                                'email' => $data['email'],
                                'description' => $data['description'],
                                ]));                                 
            );**/
    public function persist($data)
    { 

        $name =  (!isset($data['name'])) ? '' : $data['name'];
        $email = (!isset($data['email'])) ? '' : $data['email'];
        $description = (!isset($data['description'])) ? '' : utf8_decode($data['description']);

                $mailer = new Mailer;
                $view = "

                            <span><h3>NOME DE QUEM DENUNCIOU:</h3>

                                $name

                            </span>


                                <hr>
                                <br>
                        <span><h3>EMAIL DE QUEM DENUNCIOU:</h3> 

                                $email  


                        <hr><br><br> 
                        <h1>DENUNCIA:</h1><hr>  

                                $description 


                                <hr>                                      ";
           

                if(!empty($data['name']) and !empty($data['email']) and !empty($data['description'])):
                    try {   
                        $mailer->setSubject('KimPages - Denuncia');
                        $mailer->setMessage($view);
    
                $mailer->send("juridico@mazukim.com.br", $data['name']);
                $this->defineMensagem('success', 'Denuncia enviada para juridico@mazukim.com.br');
                $this->router->redirect("/denuncie");
            } catch(Exception $e) {
                $this->defineMensagem('error', 'Ocorreu um erro ao enviar a denuncia.');
                $this->router->redirect("/denuncie");
            }

                else:
                $this->defineMensagem('error', 'Alguma das informações ficaram vazias.');
                $this->router->redirect("/denuncie");
                endif;
    }
}
