<?php



namespace Template\Controller;



use League\Plates\Engine;

use Template\Entity\Brand;

use Template\Entity\Config;



use CoffeeCode\Router\Router;

use Template\Helper\FlashMessageTrait;
use Template\Helper\Filter;


use Doctrine\ORM\EntityManagerInterface;



class Configs 

{

    use FlashMessageTrait, Filter;



    private $view;

    private $router;

    private $repository;

    private $repositoryBrand;



    public function __construct(EntityManagerInterface $entityManager)

    {

        $this->view = new Engine(__DIR__ . '/../../views/admin/');

        $this->entityManager = $entityManager;

        $this->repository = $entityManager->getRepository(Config::class);

        $this->repositoryBrand = $entityManager->getRepository(Brand::class);

        $this->router = new Router(URL_BASE);

    }



    public function index()

    {

        echo $this->view->render('configuracoes', [

            'brand' => $this->repositoryBrand->findOneBy(['id' => 1]),

            'setting' => $this->repository->findOneBy(['id' => 1])

        ]);

    }

   public function persistOnlyLead($data) {
    $entity = $this->entityManager;
    $lead = $data['lead'];

    $queryBuilder = $entity->createQueryBuilder();
    $query = $queryBuilder->update('Template\Entity\Config', 'u')
        ->set('u.lead',$lead)
        ->where('u.id = 1')
        ->getQuery();
    $result = $query->execute();
}

    public function persist($data)

    {



        if (isset($data['id'])) {

            $id = filter_var(

                $data['id'],

                FILTER_VALIDATE_INT

            );

        }

     
       

        $url = Filter::string(isset($data['url']) ? $data['url'] : '');

        $title = Filter::string(isset($data['title']) ? $data['title'] : '');

        $email = Filter::string(isset($data['email']) ? $data['email'] : '');

        $phone = Filter::string(isset($data['phone']) ? $data['phone'] : '');

        $whatsapp = Filter::string(isset($data['whatsapp']) ? $data['whatsapp'] : '');

        $address = Filter::string(isset($data['address']) ? $data['address'] : '');

        $cnpj = Filter::string(isset($data['cnpj']) ? $data['cnpj'] : '');

        if (isset($data['helpkim'])) {

            $helpkim = filter_var(

                $data['helpkim'],

                FILTER_VALIDATE_INT

            );

        }

        $iframe = Filter::string(isset($data['iframe']) ? $data['iframe'] : '');


        $config = new Config();

        (isset($data['id'])) ? $config->setId($id) : '';

        $config->setUrl($url);

        $config->setTitle($title);

        $config->setEmail($email);

        $config->setPhone($phone);

        $config->setWhatsapp($whatsapp);

        $config->setAddress($address);

        $config->setIdHelpkim($helpkim);


        $config->setCnpj($cnpj);

        $config->setIframe($iframe);

        if(isset($data['lead']) and $data['lead'] == 'on'):
            $lead= 1;
        else:
            $lead = 0;
        endif;

        $config->setLead($lead);


        try {

            if(isset($data['id'])){

                $this->entityManager->merge($config);

            } else {
           

                $this->entityManager->persist($config);

            }

            $this->defineMensagem('success', "Configurações Alteradas com sucesso!");

            $this->entityManager->flush();

            $this->router->redirect("/setting");

        } catch (\Throwable $th) {

            $this->defineMensagem('error', "Não foi possivel alterar as configurações. Erro: {$th->getMessage()}");

            $this->router->redirect("/setting");

        }

    }



}

