<?php

namespace Template\Controller;

use League\Plates\Engine;
use Template\Entity\Brand;
use CoffeeCode\Router\Router;
use CoffeeCode\Uploader\Image;
use Template\Helper\FlashMessageTrait;
use Doctrine\ORM\EntityManagerInterface;
use Template\Entity\Config;

class Brands 
{
    use FlashMessageTrait;

    private $view;
    private $router;
    private $repository;
    private $repositoryConfig;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->view = new Engine(__DIR__ . '/../../views/admin/');
        $this->entityManager = $entityManager;
        $this->repository = $entityManager->getRepository(Brand::class);
        $this->repositoryConfig = $entityManager->getRepository(Config::class);
        $path = 'public/admin/images';
        $this->upload = new Image($path, "images", 600);
        $this->router = new Router(URL_BASE);
    }

    public function index()
    {
        echo $this->view->render('logo', [
            'brand' => $this->repository->findOneBy(['id' => 1]),
            'setting' => $this->repositoryConfig->findOneBy(['id' => 1])
        ]);
    }

    public function persistLogo($data)
    {

        if (isset($data['id'])) {
            $image = $this->repository->findOneBy(['id' => $data['id']]);
            $id = filter_var(
                $data['id'],
                FILTER_VALIDATE_INT
            );
        }

        if ($_FILES['logo']['size'] > 0) {
            if (filesize($_FILES['logo']['tmp_name']) >= 33554432 || $_FILES['logo']['type'] != mime_content_type($_FILES['logo']['tmp_name']) || !preg_match('/^image\/(pjpeg|jpeg|png|gif|bmp|jpg)$/', $_FILES['logo']['type'])) {
                $this->defineMensagem('error', "Essa não é uma imagem válida, tente novamente com outra imagem!");
                $this->router->redirect("/brand");
            }
            try {
                if (isset($data['id'])) {
                    $image = $this->repository->findOneBy(['id' => $id]);
                    unlink($image->getLogo());
                }
                $upload = $this->upload->upload($_FILES['logo'], 'logo');
            } catch (Exception $e) {
                $this->defineMensagem('error', "{$e->getMessage()}");
                $this->router->redirect("/brand");
            }
        } else {
            $this->defineMensagem('error', "Por favor, insira uma imagem para continuar...");
            $this->router->redirect("/brand");
        }
        
        $brand = new Brand();
        (isset($data['id'])) ? $brand->setId($id) : '';
        $brand->setLogo($upload);
        (isset($image) && !empty($image->getIcon())) ? $brand->setIcon($image->getIcon()) : $brand->setIcon('');
        $brand->setSize((isset($data['size']) and !empty($data['size'])) ? $data['size'] : '1');



        try {
            if(isset($data['id'])){
                $this->entityManager->merge($brand);
            } else {
                $this->entityManager->persist($brand);
            }
            $this->defineMensagem('success', "Logo Alterada com sucesso!");
            $this->entityManager->flush();
            $this->router->redirect("/brand");
        } catch (\Throwable $th) {
            $this->defineMensagem('error', "Não foi possivel alterar a logo. Erro: {$th->getMessage()}");
            $this->router->redirect("/brand");
        }
    }


        public function persistOnlySize($data){
           try { 
            $entity = $this->entityManager;
            $brand = $this->repository->findOneBy(['id' => 1]);
            $brand->setSize((isset($data['size']) and !empty($data['size'])) ? $data['size'] : '1');
            $entity->persist($brand);
            $entity->flush();
                }
            catch(Exception $e) {
            $this->defineMensagem('error', "Não foi possivel alterar a logo. Erro: {$th->getMessage()}");
            $this->router->redirect("/brand");

            }
        }
    public function persistIcon($data)
    {

        if (isset($data['id'])) {
            $image = $this->repository->findOneBy(['id' => $data['id']]);
            $id = filter_var(
                $data['id'],
                FILTER_VALIDATE_INT
            );
        }

        if ($_FILES['icon']['size'] > 0) {
            if ($_FILES['icon']['type'] != mime_content_type($_FILES['icon']['tmp_name']) || !preg_match('/^image\/(pjpeg|jpeg|png|gif|bmp|jpg)$/', $_FILES['icon']['type'])) {
                $this->defineMensagem('error', "Essa não é uma imagem válida, tente novamente com outra imagem!");
                $this->router->redirect("/brand");
            }
            try {
                if (isset($data['id'])) {
                    $image = $this->repository->findOneBy(['id' => $id]);
                    unlink($image->getIcon());
                }
                $upload = $this->upload->upload($_FILES['icon'], 'favicon');
            } catch (Exception $e) {
                $this->defineMensagem('error', "{$e->getMessage()}");
                $this->router->redirect("/brand");
            }
        } else {
            $this->defineMensagem('error', "Por favor, insira uma imagem para continuar...");
            $this->router->redirect("/brand");
        }
        
        $brand = new Brand();
        (isset($data['id'])) ? $brand->setId($id) : '';
        $brand->setIcon($upload);
        (isset($image) && !empty($image->getLogo())) ? $brand->setLogo($image->getLogo()) : $brand->setLogo('');
        $brand->setSize((isset($image) && !empty($image->getSize())) ? $image->getSize() : '1');

        try {
            if(isset($data['id'])){
                $this->entityManager->merge($brand);
            } else {
                $this->entityManager->persist($brand);
            }
            $this->defineMensagem('success', "Icone Alterado com sucesso!");
            $this->entityManager->flush();
            $this->router->redirect("/brand");
        } catch (\Throwable $th) {
            $this->defineMensagem('error', "Não foi possivel alterar o icone da página. Erro: {$th->getMessage()}");
            $this->router->redirect("/brand");
        }
    }

    public function deleteLogo()
    {
        $image = $this->repository->findOneBy(['id' => 1]);
        unlink($image->getLogo());
        $brand = new Brand();
        $brand->setId(1);
        $brand->setLogo('');
        (isset($image) && !empty($image->getIcon())) ? $brand->setIcon($image->getIcon()) : $brand->setIcon('');
        $brand->setSize((isset($image) and !empty($image->getSize())) ? $image->getSize() : '1');
        
        try {
            $this->entityManager->merge($brand);
            $this->entityManager->flush();
            $this->defineMensagem('success', "Logo Excluido com sucesso!");
            $this->router->redirect("/brand");
        } catch (\Throwable $th) {
            $this->defineMensagem('error', "Não foi possivel remover a logo. Erro: {$th->getMessage()}");
            $this->router->redirect("/brand");
        }
    }

    public function deleteIcon()
    {
        $image = $this->repository->findOneBy(['id' => 1]);
        unlink($image->getIcon());
        $brand = new Brand();
        $brand->setId(1);
        $brand->setIcon('');
        (isset($image) && !empty($image->getLogo())) ? $brand->setLogo($image->getLogo()) : $brand->setLogo('');
        $brand->setSize((isset($image) and !empty($image->getSize())) ? $image->getSize() : '1');

        try {
            $this->entityManager->merge($brand);
            $this->entityManager->flush();
            $this->defineMensagem('success', "Icon Excluida com sucesso!");
            $this->router->redirect("/brand");
        } catch (\Throwable $th) {
            $this->defineMensagem('error', "Não foi possivel remover o icon da pagina. Erro: {$th->getMessage()}");
            $this->router->redirect("/brand");
        }
    }

}
