<?php

namespace Template\Controller;

use League\Plates\Engine;
use Template\Entity\User;
use Template\Entity\Brand;
use Template\Entity\Config;
use Template\Entity\Social;
use Template\Entity\Company;
use Template\Entity\Contact;
use Template\Entity\Service;
use Template\Entity\Material;
use Template\Entity\ServiceAd;
use Template\Entity\Simulator;
use CoffeeCode\Paginator\Paginator;
use Doctrine\ORM\EntityManagerInterface;
use Template\Entity\Google;

class Blog 
{

    private $view;
    private $repositorioCompany;
    private $repositorioContact;
    private $repositorioSimulator;
    private $repositorioService;
    private $repositorioServiceAds;
    private $repositorioMaterial;
    private $repositorioAnalitycs;
    private $repositoryBrand;
    private $repositorySocial;
    private $repositoryConfig;
    private $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->view = new Engine(__DIR__ . '/../../views/site/');
        $this->entityManager = $entityManager;
        $this->repositorioCompany = $entityManager->getRepository(Company::class);
        $this->repositorioSimulator = $entityManager->getRepository(Simulator::class);
        $this->repositorioContact = $entityManager->getRepository(Contact::class);
        $this->repositorioService = $entityManager->getRepository(Service::class);
        $this->repositorioServiceAds = $entityManager->getRepository(ServiceAd::class);
        $this->repositorioMaterial = $entityManager->getRepository(Material::class);
        $this->repositorioAnalitycs = $entityManager->getRepository(Google::class);
        $this->repositoryBrand = $entityManager->getRepository(Brand::class);
        $this->repositorySocial = $entityManager->getRepository(Social::class);
        $this->repositoryConfig = $entityManager->getRepository(Config::class);
        $this->repositoryUser = $entityManager->getRepository(User::class);
    }

    public function index($data)
    {
        $page = filter_var(
            $data['page'],
            FILTER_SANITIZE_STRIPPED
        );

        $post = $this->repositorioMaterial->findAll();

        $paginator = new Paginator(URL_BASE . "blog/", '', ["Primeira Página", "Primeira"], ["Última Página", "Última"]);
        $paginator->pager(count($post), 6, $page, 1);

        $query_select = "SELECT m FROM Template\Entity\Material m ORDER BY m.id DESC";

        $query = $this->entityManager
        ->createQuery($query_select)
        ->setFirstResult($paginator->offset())
        ->setMaxResults($paginator->limit());
  
        $posts = $query->getResult();

        echo $this->view->render('blog', [
            'material' => $posts,
            'paginator' => $paginator,
            'service' => $this->repositorioService->findAll(),
            'material' => $this->repositorioMaterial->findAll(),
            'social' => $this->repositorySocial->findOneBy(['id' => 1]),
            'brand' => $this->repositoryBrand->findOneBy(['id' => 1]),
            'setting' => $this->repositoryConfig->findOneBy(['id' => 1]),
            'company' => $this->repositorioCompany->findOneBy(['id' => 1]),
            'contact' => $this->repositorioContact->findOneBy(['id' => 1]),
            'simulator' => $this->repositorioSimulator->findOneBy(['id' => 1]),
            'serviceads' => $this->repositorioServiceAds->findOneBy(['id' => 1]),
            'google' => $this->repositorioAnalitycs->findOneBy(['id' => 1])
        ]);
    }

    public function material(array $data)
    {
        $id = filter_var(
            $data['id'],
            FILTER_VALIDATE_INT
        );

        echo $this->view->render('artigo', [
            'materialById' => $this->repositorioMaterial->find($id),
            'service' => $this->repositorioService->findAll(),
            'material' => $this->repositorioMaterial->findAll(),
            'social' => $this->repositorySocial->findOneBy(['id' => 1]),
            'brand' => $this->repositoryBrand->findOneBy(['id' => 1]),
            'setting' => $this->repositoryConfig->findOneBy(['id' => 1]),
            'company' => $this->repositorioCompany->findOneBy(['id' => 1]),
            'contact' => $this->repositorioContact->findOneBy(['id' => 1]),
            'simulator' => $this->repositorioSimulator->findOneBy(['id' => 1]),
            'serviceads' => $this->repositorioServiceAds->findOneBy(['id' => 1]),
            'google' => $this->repositorioAnalitycs->findOneBy(['id' => 1]),
            'id' => $id
        ]);
    }
}
