<?php 

use Template\Entity\Color;
use Template\Entity\Brand;
use Template\Entity\Config;


require __DIR__ . '/../../../vendor/autoload.php';

header("Content-type: text/css; charset: UTF-8");

$entityManager = require __DIR__ . '/../../../config/dependencies.php';
$repositoryColor = $entityManager->getRepository(Color::class);
$color = $repositoryColor->findOneBy(['id' => 1]);

try {
    $repositoryBrand = $entityManager->getRepository(Brand::class);
    $brand = $repositoryBrand->findOneBy(['id' => 1]);
    $brand = !is_null($brand)  ? $brand->getSize() : '1';
}
catch(Exception $e){
    $brand = '1';
}

$repositoryLead = $entityManager->getRepository(Config::class);
$lead = $repositoryLead->findOneBy(['id' => 1]);

// if (!empty($lead) && !is_null($lead)) {
//     $lead = $lead->getLead();
// } else {
//     $lead = false;
// }
$lead = false;
?>
.whatsapp {
    position: fixed;
    bottom: 20px;
    right: 20px;
    z-index: 9999;
    max-width: 370px;
    width: 100% !important;
}


.whatsapp:hover .float {
    
    opacity: 1;
    
    height: 65% !important;
}
.whatsapp img {
    width: 100%;
    height: 70px;
    object-fit: contain;
    object-position: right;
}

.float {
    
    opacity: 0;
    height: 0 !important;
    
    position: relative;
    overflow: hidden;
    transition: all .5s;
    
}

.float p {
    font-size: .9em !important;
    line-height: 1.25em !important;
    padding: 20px;
    background-color: #075E54 !important;
    margin: 0 !important;
    color: white;
}

.float label {
    padding: 0 !important;
    display: block !important;
    font-weight: bold;
    color: #000 !important;
    margin-top: 10px !important;
}

.float form {
    width: 100% !important;
    background-color: #ccc !important;
    padding: 40px !important;
    padding-top: 10px !important;
}

.float input,
.float select {
    width: 100% !important;
    padding-left: 1em !important;
    height: 3em !important;
    line-height: 3em !important;
    border: 1px solid #ccc !important;
    background-color: #fff !important;
    margin: 0 !important;
    background-color: white !important;
}

.float select {
    width: 100% !important;
    height: 3em !important;
    margin: 0 !important;
}

.float input {
    width: calc(100% - 1.1em) !important;
    height: 3em !important;
    margin: 0 !important;
}

.float button {
    margin-top: 20px;
    width: 100%;
    height: 3em;
    background-color: #34ad32;
    color: white !important;
    font-weight: bold;
    border: none !important;
    font-size: 1.25em;
    text-transform: none;
    box-shadow: none !important;
    cursor: pointer !important;
}

.float label:nth-of-type(2) {
    width: 40% !important;
    float: left;
}

.float label:nth-of-type(3) {
    width: 60% !important;
    float: left;
    padding-top: 20px !important;
}

.btn-floating {
    margin-top: 10px;
    float: right;
    width: 220px !important;
    height: auto !important;
    padding: 15px 30px  !important;;
    border-radius: 40px !important;
    text-align: center;
    line-height: .7em  !important;;
    font-size: 1.1em  !important;;
    background-color: #34af23 !important;
}

.btn-floating strong {
    margin-top: .5vw;
    font-size: .9em;
    width: 100%;
    float: left;
}
<!-- 
/*-------- Whatsapp-form --------*/


 .whatsapp-form {
    position: fixed;
    bottom: 20px;
    right: 20px;
    z-index: 9999;
    max-width: 350px;
    width: 100%;
    padding-left: 20px;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
}


.whatsapp-form .action {

    width: 100%;

    padding-right:0px;
    padding-bottom:0px;

    text-align: right;

    display: flex;

    justify-content: flex-end;

    flex-wrap: wrap;

}



.whatsapp-form .action .clearfix {

    width: 100%;

    float: left;

}



.whatsapp-form .action hgroup {

    background-color: #fff !important;

    padding: 15px 20px;

    border-radius: 10px 10px 0 10px;

    position: relative;

    text-align: center;

    max-width: 200px;

    margin-bottom: 15px;

    margin-right: 10px;

    box-shadow: 0 0 5px 2px rgba(0, 0, 0, .3);

}



.whatsapp-form .action hgroup::before {

    content: '';

    position: absolute;

    bottom: -15px;

    right: 0;

    width: 0;

    height: 0;

    border-style: solid;

    border-width: 15px 15px 0 15px;

    border-color: #008000 transparent transparent transparent;

}



.whatsapp-form .action h2 {

    font-size: .8em;

    margin: 0;

}



.whatsapp-form .action p {

    font-size: 1.25em;

    font-weight: bold;

    margin: 0;

}



.whatsapp-form .action .close {

    position: absolute;

    width: 20px;

    height: 20px;

    background-color: #fff;

    border-radius: 50%;

    top: -5px;

    right: -5px;

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    font-size: .8em;

    line-height: 22px;

}



.whatsapp-form .btn-floating {

    background-color: #008000 !important;

    width: 50px;

    height: 50px;

    line-height: 50px;

    font-size: 1.75em;

}



.whatsapp-form .form {

    background-color: white;

    border-radius: 10px;

    position: relative;

    overflow: hidden;

    box-shadow: 0 0 5px 2px rgba(0, 0, 0, .3);

    display: none;

}



.whatsapp-form .form header {

    display: flex;

    align-items: center;

    flex-wrap: nowrap;

    background-color: #008000;

    padding: 20px;

    position: relative;

}



.whatsapp-form .form img {

    width: 50px;

    height: 50px;

    border-radius: 50%;

    background-color: white;

    object-fit: contain;

    padding: 5px;

    margin-right: 10px;

}



.whatsapp-form .form h3 {

    font-size: 1.1em;

    font-weight: bold;

    margin: 0;

    color: white;

}



.whatsapp-form .form p {

    font-size: .8em;

    margin-top: 5px;

    margin-bottom: 0;

    line-height: 1.25em;

    color: white;

}



.whatsapp-form .form a {

    position: absolute;

    right: 10px;

    top: 0px;

    font-size: 2em;

    color: white;

}



.whatsapp-form .form fieldset {

    padding: 20px !important;

}



.whatsapp-form .form input {

    border: 1px solid #999 !important;

    border-radius: 5px !important;

    padding-left: 1em !important;

    width: calc(100% - 1.1em) !important;

    margin: 0 !important;

    margin-bottom: 10px !important;

    font-size: 1em !important;

    box-shadow: none !important;

    outline: none !important;

}



.whatsapp-form .form textarea {

    border: 1px solid #999 !important;

    border-radius: 5px !important;

    padding: 1em !important;

    margin: 0 !important;

    margin-bottom: 5px !important;

    resize: none;

    height: 6em !important;

    box-shadow: none !important;

    outline: none !important;

}



.whatsapp-form .form input::placeholder,

.whatsapp-form .form textarea::placeholder {

    color: #666;

}



.whatsapp-form .form .btn {

    width: 100%;

    background-color: #008000 !important;

    box-shadow: none !important;

    text-transform: none !important;

    border-radius: 10px;

    height: 3em;

    line-height: 3em;

}

.float {
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    position: fixed;
    bottom: 10px;
    right: 10px;
    z-index: 1000;
    display: <?php if($lead):?> none <?php else: ?> initial <?php endif; ?>;
}

.float .btn-floating {
    width: 50px !important;
    height: 50px !important;
    text-align: center;
    font-size: 1.5em !important;
    background-color: #34af23 !important;
    line-height: 50px;
    box-shadow: none !important;
    width: 200px !important;
    height: auto !important;
    border-radius: 30px !important;
    font-size: 1.1em !important;
    padding: 10px 20px;
    line-height: 20px;
    box-shadow: none !important;
}

.float p {
    font-size: .7em;
    margin: 0;
    line-height: 1.25em;
    margin-bottom: 0em;
}

.float strong {
    font-weight: normal !important;
}

.float svg {
    float: left;
    margin-right: -5px;
    margin-top: 2px;
    margin-left: 10px;
} -->

/*-------- Headline --------*/



.headline {

    position: relative;

    padding: 60px 5%;

    min-height: 100vh;

    display: flex;

    align-content: center;

    flex-wrap: wrap;

    justify-content: center;

}



.headline::before {

    content: '';

    position: absolute;

    left: 0;

    top: 0;

    width: 100%;

    height: 100%;

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    opacity: .9;

}



.headline h1 {

    width: 100%;

    float: left;

    position: relative;

    text-align: center;

    font-size: 2.5em;

    font-weight: bold;

    color: white;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

    margin: 0;

    margin-top: 1em;

}



.headline p {

    width: 100%;

    float: left;

    position: relative;

    text-align: center;

    font-size: 1.25em;

    color: white;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

    margin: 0;

}



.headline figure img:first-child {

    width: 100%;

    height: 100%;

    object-fit: cover;

    position: absolute;

    top: 0;

    left: 0;

    z-index: -1;

}



.headline figure img:nth-of-type(2) {

    width: 100%;

    float: left;

            <?php   if($brand =='1'): ?>    height: 70px; <?php endif;?>
            <?php   if($brand =='2'): ?>    height: 140px; <?php endif;?>
            <?php   if($brand =='3'): ?>    height: 210px; <?php endif;?>
    object-fit: contain;

    position: relative;

    filter: contrast(0%) brightness(1000%);

}



.headline fieldset {

    width: 100%;

    float: left;

    position: relative;

    display: flex !important;

    justify-content: center;

}



.headline form {

    width: 100%;

    max-width: 500px;

    margin-top: 2em;

}



.headline label {

    width: 100% !important;

    float: left;

    display: none;

}



.headline form label:first-child {

    display: block;

}



.headline .btn {

    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;

    height: 3em;

    line-height: 3em;

    text-transform: none;

    font-weight: bold;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

    box-shadow: none !important;

    border-radius: 30px !important;

}



.headline label {

    color: white !important;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

    font-size: 1em;

}



.headline input {

    border: 1px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;

    border-radius: 5px !important;

    margin-top: 10px !important;

    padding-left: 1em !important;

    width: calc(100% - 1.1em) !important;

    box-shadow: none !important;

    outline: none !important;

}



.headline select {

    border: 1px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;

    border-radius: 5px !important;

    margin-top: 10px !important;

    background-color: transparent !important;

    margin-bottom: 10px !important;

    box-shadow: none !important;

    outline: none !important;

    padding-left: 1em !important;

}



.headline select option {

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;

}



.headline textarea {

    border: 1px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;

    border-radius: 5px !important;

    margin-top: 10px !important;

    background-color: transparent !important;

    margin-bottom: 10px !important;

    box-shadow: none !important;

    outline: none !important;

    padding: 1em !important;

    min-height: 8em !important;

    resize: none;

}



.headline input::placeholder,

.headline textarea::placeholder {

    color: #999 !important;

}



input[type=number]::-webkit-inner-spin-button {

    -webkit-appearance: none;

}



input[type=number] {

    -moz-appearance: textfield;

    appearance: textfield;

}



.headline .flex {

    display: flex;

    align-items: center;

    justify-content: center;

    flex-wrap: wrap;

    margin: 20px 0;

}



.headline .flex p {

    width: fit-content !important;

    margin: 5px 10px;

}



.headline .flex label {

    color: #ccc !important;

}



.headline [type="radio"]:not(:checked)+label:before,

.headline [type="radio"]:not(:checked)+label:after {

    border: 1px solid #fff !important;

}



.headline [type="checkbox"]:not(:checked)+label:before,

.headline [type="checkbox"]:not(:checked)+label:after {

    border: 1px solid #fff !important;

}



.headline [type="radio"]:checked+label:after,

.headline [type="radio"].with-gap:checked+label:after {

    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;

    border-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;

}



.headline [type="checkbox"]:checked+label:before {

    border-right: 2px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;

    border-bottom: 2px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;

}



.headline .number {

    display: flex;

    align-items: center;

    flex-wrap: nowrap;

}



.headline .number hgroup {

    width: min-content !important;

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;

    border: 1px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;

    height: auto !important;

    padding: 0 !important;

    margin: 0 !important;

    height: 3.12em !important;

    margin-top: -10px !important;

}



.headline .number input {

    width: 100% !important;

    border-right: none !important;

    border-radius: 5px 0 0 5px !important;

}



.headline .number button {

    margin: 0 !important;

    padding: 0 !important;

    background-color: transparent !important;

    border: none !important;

    font-size: .9em;

    width: 30px;

}



.headline .number button:first-child {

    border-bottom: 1px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;

}



.headline .character-counter {

    width: 100%;

    float: left;

    font-size: 12px;

    height: 1px;

    text-align: right;

    margin-bottom: 20px;

}



.headline .foot {

    width: 100%;

    float: left;

}



.headline .foot .btn,

.headline .foot button:first-child {

    display: none;

}



.headline .foot hgroup {

    display: flex;

    align-items: center;

    justify-content: space-between;

}



.headline .foot hgroup button {

    margin: 0 !important;

    padding: 0 !important;

    background-color: transparent !important;

    border: none !important;

    display: flex;

    align-items: center;

    flex-wrap: nowrap;

    justify-content: end;

    width: 100%;

}



.headline .foot hgroup button p {

    font-size: 1em;

    font-weight: bold;

    margin: 0 !important;

    white-space: nowrap;

    transition: .5s all;

    width: 160px;

}



.headline .foot hgroup button svg {

    color: white;

    font-size: 3em;

}



.headline .foot.active button:first-child {

    display: block;

}



.headline .foot.active hgroup button {

    justify-content: initial;

    width: auto;

}



.headline .foot.active hgroup button p {

    width: 0 !important;

    overflow: hidden;

}



.headline fieldset {

    position: relative;

    z-index: 1;

}



.headline svg:not(.svg-inline--fa) {

    position: absolute;

    bottom: 0px;

    left: 0;

    width: 100%;

    color: #fff !important;

}



.headline svg:not(.svg-inline--fa) path {

    fill: #fff;

}



@media (min-width: 601px) {

    .headline svg:not(.svg-inline--fa) {

        bottom: -60px;

    }

}





/*-------- Services --------*/



.services {

    padding: 60px 10%;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

}



.services .item {

    display: flex;

    align-items: center;

    flex-wrap: wrap;

}



.services .owl-item .item {

    display: none;

}



.services .owl-item.active .item {

    display: flex !important;

}



.services .col {

    margin-top: 2em;

}



.services h2 {

    font-size: 2em;

    font-weight: bold;

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    margin-top: 0;

}



.services p {

    font-size: 1.25em;

    line-height: 1.25em;

    color: #666;

}



.services ul {

    padding-left: 2em !important;

}



.services ul li {

    list-style: disc !important;

}



.services .item a {

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    font-weight: bold;

}



.services .owl-nav {

    width: 100%;

    display: flex;

    justify-content: space-between;

    margin-top: 40px;

    padding: 0 .75rem;

}



.services .owl-nav button {

    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;

    border-radius: 5px;

    border: none;

    color: white;

    padding: 5px 1em;

    transition: .5s all;

}



.services .owl-nav button.disabled {

    opacity: 0;

    cursor: initial !important;

}



.services .owl-dots {

    width: 100%;

    display: flex;

    justify-content: center;

    margin-top: 40px;

}



.services .owl-dot {

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    border: none;

    width: 30px;

    height: 8px;

    margin: 0 2.5px;

    border-radius: 30px;

    padding: 0 .75rem;

    transition: .5s all;

}



.services .owl-dot.active {

    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;

}



@media (min-width: 601px) {

    .services .double {

        display: none;

    }

}





/*-------- Empresa --------*/



.empresa {

    width: 100%;

    float: left;

    position: relative;

    padding: 120px 10%;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

    overflow: hidden;

}



.empresa img {

    width: 100%;

    height: 100%;

    position: absolute;

    top: 0px;

    left: 0;

    object-fit: cover;

    z-index: -1;

}



.empresa figure::before {

    content: '';

    position: absolute;

    left: 0;

    top: 0;

    width: 100%;

    height: 100%;

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    opacity: .9;

}



.empresa::after {

    content: '';

    width: 0;

    height: 0;

    border-style: solid;

    border-width: 0 0 100px 200vh;

    border-color: #fff transparent transparent #fff;

    position: absolute;

    right: 0;

    top: 0px;

}



.empresa::before {

    content: '';

    width: 0;

    height: 0;

    border-style: solid;

    border-width: 0 0 100px 200vh;

    border-color: #fff transparent transparent #fff;

    position: absolute;

    left: 0;

    bottom: 0px;

    transform: rotate(180deg);

    z-index: 1;

}



.empresa article {

    position: relative;

    z-index: 1;

}



.empresa h2 {

    font-size: 2em;

    font-weight: bold;

    color: white;

}



.empresa p {

    color: white;

    font-size: 1.25em;

    line-height: 1.25em;

}



@media (min-width: 993px) {

    .empresa::after {

        border-width: 0 0 100px 300vh;

    }

    .empresa::before {

        border-width: 0 0 100px 300vh;

    }

}





/*-------- Perguntas Frequentes --------*/



.questions {

    width: 100%;

    float: left;

    padding: 120px 10%;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

}



.questions h2 {

    font-size: 2em;

    font-weight: bold;

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    text-align: center;

}



.questions a {

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    font-weight: bold;

}



.questions .collapsible-body ul {

    padding-left: 2em !important;

}



.questions .collapsible-body ul li {

    list-style: disc !important;

}



.questions .collapsible {

    box-shadow: none;

    border: none;

    margin-top: 30px;

    transition: all 1s;

}



.questions .active .collapsible-header {

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    outline: none !important;

}



.questions .collapsible-header {

    display: flex;

    align-items: center;

    padding: 15px 10px;

    border: none;

    outline: none !important;

    border-left: 10px solid <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    margin-top: 10px;

}



.questions .active .collapsible-header {

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    color: white;

}



.questions h3 {

    width: 100%;

    margin: 0;

    font-size: 1em;

    font-weight: bold;

    margin-left: 10px;

    display: flex;

    align-items: center;

    justify-content: space-between;

}



.questions .svg svg {

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

}



.questions .active .svg svg {

    color: #fff;

}



.questions h3 svg {

    margin-left: 5px;

    transition: .5s all;

}



.questions .collapsible-body {

    padding: 10px;

    border: none;

    border-bottom: 10px solid <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

}



.questions .active h3 svg {

    transform: rotate(180deg);

}



.questions ul {

    margin: 0 !important;

}



@media(min-width: 601px) {

    .questions .col {

        margin-top: 2em;

    }

}





/*-------- Depoimentos --------*/



.depoimentos {

    width: 100%;

    float: left;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

}



.depoimentos .owl-item .item {

    display: none;

}



.depoimentos .owl-item.active .item {

    display: flex !important;

    flex-wrap: wrap;

}



.depoimentos small {

    width: 100%;

    float: right;

    text-align: right;

    font-size: 1em;

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    font-weight: bold;

}



.depoimentos .item svg {

    width: 50px !important;

    height: 50px !important;

    float: left;

    background-color: white !important;

    border-radius: 50%;

    position: absolute;

    top: 0px;

    left: calc(50% - 25px - 10%);

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    padding: 10px !important;

}



.depoimentos .item {

    width: 100%;

    float: left;

    padding-top: 80px !important;

    background-color: white;

    padding: 20px;

    border-radius: 20px;

    box-shadow: 0 0 10px 5px rgba(0, 0, 0, .3);

    margin-top: 15px;

    width: calc(100% - 20%);

}



.depoimentos .owl-stage-outer {

    padding: 60px 10%;

}



.depoimentos figure {

    position: relative;

}



.depoimentos figure::before {

    content: '';

    width: 100%;

    height: 250px;

    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;

    position: absolute;

    right: 70px;

    top: -40px;

}



.depoimentos figure::after {

    content: '';

    width: 20px;

    height: 250px;

    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;

    position: absolute;

    right: -89px;

    top: calc(50% - 80px);

}



.depoimentos img {

    box-shadow: 0 0 10px 0px rgba(0, 0, 0, .3);

    padding: 10px;

    margin-bottom: 1em;

    height: 250px;

    object-fit: cover;

    object-position: top;

    position: relative;

    background-color: white;

}



.depoimentos q {

    font-size: 1.1em;

    color: #666;

    line-height: 1.25em;

    width: 100%;

    float: left;

}



.depoimentos cite {

    float: right;

    font-size: 1.5em;

    font-weight: bold;

    color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;

    margin-top: 10px;

}



.depoimentos .owl-nav {

    width: 100%;

    display: flex;

    justify-content: space-between;

    margin-top: -50px;

    padding: 10px 10%;

    padding-bottom: 60px;

    position: relative;

    z-index: 1;

}



.depoimentos .owl-nav button {

    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;

    border-radius: 5px;

    border: none;

    color: white;

    padding: 5px 1em;

    transition: .5s all;

}



.depoimentos .owl-nav button.disabled {

    opacity: 0;

    cursor: initial !important;

}



.depoimentos .owl-dots {

    position: absolute;

    top: 20px;

    right: 0;

    padding: 10px 10%;

}



.depoimentos .owl-dot {

    background-color: #fff;

    border: none;

    width: 30px;

    height: 8px;

    margin: 0 2.5px;

    border-radius: 30px;

    padding: 0 .75rem;

    transition: .5s all;

}



.depoimentos .owl-dot.active {

    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;

}



@media (min-width: 601px) {

    .depoimentos .container {

        max-width: 900px !important;

    }

    .depoimentos .owl-item.active .item {

        display: flex;

        align-items: center;

        flex-wrap: nowrap !important;

        padding: 40px;

    }

    .depoimentos img {

        width: 250px !important;

        height: 300px;

        margin-right: 40px !important;

    }

    .depoimentos figure::after {

        content: none;

    }

    .depoimentos q {

        font-size: 1.25em;

    }

    .depoimentos .item {

        position: relative;

        width: calc(100% - 20%);

    }

    .depoimentos .item::before {

        content: '';

        width: 20px;

        height: 250px;

        background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;

        position: absolute;

        right: -20px;

        top: calc(50% - 120px);

    }

    .depoimentos .svg svg {

        top: -25px !important;

        left: calc(50% - 25px);

    }

}





/*-------- Instagram --------*/



.instagram {

    width: 100%;

    float: left;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

    padding: 30px;

    position: relative;

    overflow: hidden;

}



.instagram h2 {

    font-size: 1.25em;

    line-height: 1.5em;

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    margin-bottom: 0;

}



.instagram hr {

    width: 150px;

    height: 2px;

    border: none;

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    margin-bottom: 2em;

    float: left;

}



.instagram strong {

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

    color: black;

    float: left;

    width: 100%;

    font-size: 1.5em;

}



.instagram a {

    width: 47% !important;

    border-radius: 10px;

}



.instagram img {

    display: none;

}



@media(min-width: 601px) {

    .instagram {

        padding: 3%;

    }

    .instagram h2 {

        text-align: center;

    }

    .instagram hr {

        float: none;

    }

    .instagram a {

        width: calc(100% / 3 - 2%) !important;

    }

}



@media(min-width: 993px) {

    .instagram a {

        margin: 5px !important;

        width: calc(100% / 6 - 10px) !important;

    }

}





/*-------- Galery --------*/



.galery {

    width: 100%;

    float: left;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

}



.galery .col {

    padding: 0 !important;

}



.galery img {

    width: 100%;

    height: 250px;

    object-fit: cover;

    margin-bottom: -6px;

}





/*-------- Footer --------*/



.footer {

    width: 100%;

    float: left;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

    padding: 30px;

    position: relative;

    overflow: hidden;

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

}



.footer figure img {

    width: 100%;

    height: 100px;

    object-fit: contain;

    filter: contrast(0) brightness(1000%);

}



.footer p {

    color: #ccc;

    line-height: 1.25em;

    margin-bottom: 0;

}



.footer a {

    width: 100%;

    color: #ccc;

    display: flex;

    align-items: center;

    flex-wrap: nowrap;

    justify-content: center;

}



.footer a img {

    width: 100px;

    height: auto;

    object-fit: contain;

    margin-left: 10px;

}



.footer hgroup {

    text-align: center;

}



.footer ul {

    display: flex;

    align-items: center;

    justify-content: center;

    flex-wrap: nowrap;

    margin-top: 40px !important;

    margin-bottom: 10px !important;

}



.footer svg {

    color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;

    width: 50px !important;

    font-size: 2em;

}



@media (min-width: 601px) {

    .footer {

        display: flex;

        align-items: center;

        flex-wrap: nowrap;

        justify-content: space-between;

    }

    .footer figure img {

        max-width: 300px;

    }

    .footer ul {

        margin-top: 0 !important;

    }

}



.footer .button-denuncie {
  margin-left: 44vw;
  margin-top: 42vh;
}

.footer .button-denuncielink,
.footer .button-denuncie:visited {
  text-transform: uppercase;
  text-decoration: none;
  padding: 15px 40px;
  display: inline-block;
  border-radius: 100px;
  transition: all 0.2s;
  position: absolute;
}

.footer .button-denuncie:hover {
  transform: translateY(-3px);
  box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
}

.footer .btn:active {
  transform: translateY(-1px);
  box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
}


.footer .button-denuncie:after {
  content: "";
  display: inline-block;
  height: 100%;
  width: 100%;
  border-radius: 100px;
  position: absolute;
  top: 0;
  left: 0;
  z-index: -1;
  transition: all 0.4s;
}

.footer .button-denuncie::after {
  background-color: #fff;
}

.footer .button-denuncie:hover::after {
  transform: scaleX(1.4) scaleY(1.6);
  opacity: 0;
}

.footer .btn-animated {
  -webkit-animation: moveInBottom 5s ease-out;
          animation: moveInBottom 5s ease-out;
  -webkit-animation-fill-mode: backwards;
          animation-fill-mode: backwards;
}

@-webkit-keyframes moveInBottom {
  0% {
    opacity: 0;
    transform: translateY(30px);
  }
  100% {
    opacity: 1;
    transform: translateY(0px);
  }
}

@keyframes moveInBottom {
  0% {
    opacity: 0;
    transform: translateY(30px);
  }
  100% {
    opacity: 1;
    transform: translateY(0px);
  }
}


.footer .button-denuncie {
    display: flex;
    background: white;
    flex-direction: row-reverse;
    color: black !important;
    width: 12rem !important;
    border-radius: 13px;
    margin: auto;
    margin-top: 21px;
    border: 5px solid #780000;
    transition: .3s ease-in-out;
    font-weight: bold;
    
}

.footer .button-denuncie .button-denuncie.img {
    display: flex; align-items: center; width: 3rem;background: #810000; border-radius: 12px 0 0 12px;height: inherit;
}
/*-------- Thank You Page --------*/



.thanks {

    padding: 60px 5%;

    width: 100%;

    float: left;

    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;

    display: flex;

    align-items: center;

    flex-wrap: wrap;

    text-align: center;

    min-height: 100vh !important;

}



.thanks figure.col img {

    width: 100%;

    height: auto;

}



.thanks article.col figure {

    width: 100%;

    text-align: center;

}



.thanks article.col img {

    width: 90px;

    height: 90px;

    object-fit: contain;

    border: 4px solid #008000;

    border-radius: 50%;

    padding: 10px;

    margin: 0 auto;

}



.thanks article.col h1 {

    font-size: 1.75em;

    font-weight: bold;

    margin-bottom: 5px;

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

}



.thanks article.col h2 {

    font-size: 1.25em;

    max-width: 450px;

    margin: 0 auto;

    margin-bottom: 10px;

    color: #666;

}



.thanks article.col p {

    font-size: .9em;

    color: #000;

    max-width: 300px;

    line-height: 1.25em;

    margin: 0 auto;

}



.thanks .time {

    margin: 10px auto;

    margin-top: 40px;

    position: relative;

}



.thanks .time h3 {

    margin: 0 auto;

    font-size: 3em;

    font-weight: bold;

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    border-radius: 50%;

    border: 4px solid <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    width: 80px;

    height: 80px;

    line-height: 70px;

    margin-bottom: 5px;

}



.thanks .time p {

    color: #999 !important;

}



.thanks article.col h4 {

    font-size: 1.5em;

    font-weight: bold;

    margin-right: 10px;

}



.thanks ul {

    display: flex;

    align-items: center;

    justify-content: center;

    flex-wrap: nowrap;

    margin-top: 40px !important;

    margin-bottom: 10px !important;

}



.thanks article.col svg {

    color: #fff;

    width: 40px !important;

    height: 40px;

    padding: 10px;

    border-radius: 50%;

    margin: 0 2.5px;

}



.thanks .fa-facebook-f {

    background-color: #3b5998;

}



.thanks .fa-instagram {

    background-color: #517fa4;

}



.thanks .fa-linkedin-in {

    background-color: #0976b4;

}



.thanks .fa-youtube {

    background-color: #bb0000;

}



.thanks aside {

    background-color: rgba(0, 0, 0, .7);

    position: fixed;

    top: 0;

    left: 0;

    width: 100%;

    height: 100%;

    display: flex;

    align-items: center;

    justify-content: center;

    z-index: 9999;

    transform: translateY(-100%);

    transition: all .5s;

    padding: 20px;

    backdrop-filter: blur(3px);

}



.thanks aside article {

    width: 100%;

    float: left;

    background-color: #fff !important;

    border: 4px solid <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    border-radius: 20px;

    border-bottom: 30px solid <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    max-width: 700px;

    padding: 20px;

}



.thanks aside img {

    width: 100%;

    height: 250px;

    object-fit: contain;

}



.thanks aside h2 {

    font-size: 2em;

    font-weight: bold;

    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;

    margin-top: 0;

    margin-bottom: 5px;

    font-family: 'Open Sans Bold', Tahoma, Geneva, Verdana, sans-serif;

}



.thanks aside p {

    margin: 0;

    font-size: 1.25em;

    line-height: 1.25em;

}



.thanks aside .btn {

    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;

    box-shadow: none !important;

    border-radius: 5px;

    height: auto !important;

    text-transform: none;

    line-height: 1.25em;

    width: 300px;

    padding: 10px 1em;

    margin-top: 1em;

    font-size: .9em;

}



.thanks aside .btn strong {

    width: 100%;

    float: left;

    font-size: 1.25em;

}





/*-------- TIPOGRAFIA --------*/



@font-face {

    font-family: 'Open Sans';

    src: url(../fonts/opensans-regular.ttf);

}



@font-face {

    font-family: 'Open Sans Bold';

    src: url(../fonts/opensans-bold.ttf);

}



button {

    cursor: pointer !important;

}



.row {

    margin-bottom: 0 !important;

}



nav {

    color: #000 !important;

    background-color: transparent !important;

    width: initial !important;

    height: initial !important;

    line-height: initial !important;

    box-shadow: none !important;

}



address {

    font-style: normal;

}



cite {

    font-style: normal;

}



strong {

    font-weight: bold !important;

}



figcaption {

    display: none !important;

}



figure {

    margin: 0 !important;

}



fieldset {

    border: none !important;

    margin: 0 !important;

    padding: 0 !important;

}