/* Chartist.js 0.7.4
 * Copyright © 2015 Gion Kunz
 * Free to use under the WTFPL license.
 * http://www.wtfpl.net/
 */

!function(a,b){"function"==typeof define&&define.amd?define([],function(){return a.Chartist=b()}):"object"==typeof exports?module.exports=b():a.Chartist=b()}(this,function(){var a={version:"0.7.4"};return function(a,b,c){"use strict";c.noop=function(a){return a},c.alphaNumerate=function(a){return String.fromCharCode(97+a%26)},c.extend=function(a){a=a||{};var b=Array.prototype.slice.call(arguments,1);return b.forEach(function(b){for(var d in b)a[d]="object"!=typeof b[d]||b[d]instanceof Array?b[d]:c.extend({},a[d],b[d])}),a},c.replaceAll=function(a,b,c){return a.replace(new RegExp(b,"g"),c)},c.stripUnit=function(a){return"string"==typeof a&&(a=a.replace(/[^0-9\+-\.]/g,"")),+a},c.ensureUnit=function(a,b){return"number"==typeof a&&(a+=b),a},c.querySelector=function(a){return a instanceof Node?a:b.querySelector(a)},c.times=function(a){return Array.apply(null,new Array(a))},c.sum=function(a,b){return a+b},c.serialMap=function(a,b){var d=[],e=Math.max.apply(null,a.map(function(a){return a.length}));return c.times(e).forEach(function(c,e){var f=a.map(function(a){return a[e]});d[e]=b.apply(null,f)}),d},c.roundWithPrecision=function(a,b){var d=Math.pow(10,b||c.precision);return Math.round(a*d)/d},c.precision=8,c.escapingMap={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#039;"},c.serialize=function(a){return null===a||void 0===a?a:("number"==typeof a?a=""+a:"object"==typeof a&&(a=JSON.stringify({data:a})),Object.keys(c.escapingMap).reduce(function(a,b){return c.replaceAll(a,b,c.escapingMap[b])},a))},c.deserialize=function(a){if("string"!=typeof a)return a;a=Object.keys(c.escapingMap).reduce(function(a,b){return c.replaceAll(a,c.escapingMap[b],b)},a);try{a=JSON.parse(a),a=void 0!==a.data?a.data:a}catch(b){}return a},c.createSvg=function(a,b,d,e){var f;return b=b||"100%",d=d||"100%",Array.prototype.slice.call(a.querySelectorAll("svg")).filter(function(a){return a.getAttribute(c.xmlNs.qualifiedName)}).forEach(function(b){a.removeChild(b)}),f=new c.Svg("svg").attr({width:b,height:d}).addClass(e).attr({style:"width: "+b+"; height: "+d+";"}),a.appendChild(f._node),f},c.reverseData=function(a){a.labels.reverse(),a.series.reverse();for(var b=0;b<a.series.length;b++)"object"==typeof a.series[b]&&void 0!==a.series[b].data?a.series[b].data.reverse():a.series[b].reverse()},c.getDataArray=function(a,b){var d,e,f=[];(b&&!a.reversed||!b&&a.reversed)&&(c.reverseData(a),a.reversed=!a.reversed);for(var g=0;g<a.series.length;g++){e="object"==typeof a.series[g]&&void 0!==a.series[g].data?a.series[g].data:a.series[g],e instanceof Array?(f[g]=[],Array.prototype.push.apply(f[g],e)):f[g]=e;for(var h=0;h<f[g].length;h++)d=f[g][h],d=0===d.value?0:d.value||d,f[g][h]=+d}return f},c.normalizePadding=function(a,b){return b=b||0,"number"==typeof a?{top:a,right:a,bottom:a,left:a}:{top:"number"==typeof a.top?a.top:b,right:"number"==typeof a.right?a.right:b,bottom:"number"==typeof a.bottom?a.bottom:b,left:"number"==typeof a.left?a.left:b}},c.normalizeDataArray=function(a,b){for(var c=0;c<a.length;c++)if(a[c].length!==b)for(var d=a[c].length;b>d;d++)a[c][d]=0;return a},c.getMetaData=function(a,b){var d=a.data?a.data[b]:a[b];return d?c.serialize(d.meta):void 0},c.orderOfMagnitude=function(a){return Math.floor(Math.log(Math.abs(a))/Math.LN10)},c.projectLength=function(a,b,c){return b/c.range*a},c.getAvailableHeight=function(a,b){return Math.max((c.stripUnit(b.height)||a.height())-(b.chartPadding.top+b.chartPadding.bottom)-b.axisX.offset,0)},c.getHighLow=function(a){var b,c,d={high:-Number.MAX_VALUE,low:Number.MAX_VALUE};for(b=0;b<a.length;b++)for(c=0;c<a[b].length;c++)a[b][c]>d.high&&(d.high=a[b][c]),a[b][c]<d.low&&(d.low=a[b][c]);return d},c.getBounds=function(a,b,d,e){var f,g,h,i={high:b.high,low:b.low};i.high===i.low&&(0===i.low?i.high=1:i.low<0?i.high=0:i.low=0),(e||0===e)&&(i.high=Math.max(e,i.high),i.low=Math.min(e,i.low)),i.valueRange=i.high-i.low,i.oom=c.orderOfMagnitude(i.valueRange),i.min=Math.floor(i.low/Math.pow(10,i.oom))*Math.pow(10,i.oom),i.max=Math.ceil(i.high/Math.pow(10,i.oom))*Math.pow(10,i.oom),i.range=i.max-i.min,i.step=Math.pow(10,i.oom),i.numberOfSteps=Math.round(i.range/i.step);for(var j=c.projectLength(a,i.step,i),k=d>j;;)if(k&&c.projectLength(a,i.step,i)<=d)i.step*=2;else{if(k||!(c.projectLength(a,i.step/2,i)>=d))break;i.step/=2}for(g=i.min,h=i.max,f=i.min;f<=i.max;f+=i.step)f+i.step<i.low&&(g+=i.step),f-i.step>=i.high&&(h-=i.step);for(i.min=g,i.max=h,i.range=i.max-i.min,i.values=[],f=i.min;f<=i.max;f+=i.step)i.values.push(c.roundWithPrecision(f));return i},c.polarToCartesian=function(a,b,c,d){var e=(d-90)*Math.PI/180;return{x:a+c*Math.cos(e),y:b+c*Math.sin(e)}},c.createChartRect=function(a,b,d){var e=b.axisY?b.axisY.offset||0:0,f=b.axisX?b.axisX.offset||0:0,g=c.stripUnit(b.width)||a.width(),h=c.stripUnit(b.height)||a.height(),i=c.normalizePadding(b.chartPadding,d);return{x1:i.left+e,y1:Math.max(h-i.bottom-f,i.bottom),x2:Math.max(g-i.right,i.right+e),y2:i.top,width:function(){return this.x2-this.x1},height:function(){return this.y1-this.y2}}},c.createGrid=function(a,b,d,e,f,g,h,i){var j={};j[d.units.pos+"1"]=a.pos,j[d.units.pos+"2"]=a.pos,j[d.counterUnits.pos+"1"]=e,j[d.counterUnits.pos+"2"]=e+f;var k=g.elem("line",j,h.join(" "));i.emit("draw",c.extend({type:"grid",axis:d,index:b,group:g,element:k},j))},c.createLabel=function(a,b,d,e,f,g,h,i,j,k){var l,m={};if(m[e.units.pos]=a.pos+g[e.units.pos],m[e.counterUnits.pos]=g[e.counterUnits.pos],m[e.units.len]=a.len,m[e.counterUnits.len]=f,j){var n='<span class="'+i.join(" ")+'">'+d[b]+"</span>";l=h.foreignObject(n,c.extend({style:"overflow: visible;"},m))}else l=h.elem("text",m,i.join(" ")).text(d[b]);k.emit("draw",c.extend({type:"label",axis:e,index:b,group:h,element:l,text:d[b]},m))},c.createAxis=function(a,b,d,e,f,g,h,i){var j=h["axis"+a.units.pos.toUpperCase()],k=b.map(a.projectValue.bind(a)).map(a.transform),l=b.map(j.labelInterpolationFnc);k.forEach(function(b,k){(l[k]||0===l[k])&&(j.showGrid&&c.createGrid(b,k,a,a.gridOffset,d[a.counterUnits.len](),e,[h.classNames.grid,h.classNames[a.units.dir]],i),j.showLabel&&c.createLabel(b,k,l,a,j.offset,a.labelOffset,f,[h.classNames.label,h.classNames[a.units.dir]],g,i))})},c.optionsProvider=function(b,d,e){function f(b){var f=h;if(h=c.extend({},j),d)for(i=0;i<d.length;i++){var g=a.matchMedia(d[i][0]);g.matches&&(h=c.extend(h,d[i][1]))}e&&!b&&e.emit("optionsChanged",{previousOptions:f,currentOptions:h})}function g(){k.forEach(function(a){a.removeListener(f)})}var h,i,j=c.extend({},b),k=[];if(!a.matchMedia)throw"window.matchMedia not found! Make sure you're using a polyfill.";if(d)for(i=0;i<d.length;i++){var l=a.matchMedia(d[i][0]);l.addListener(f),k.push(l)}return f(!0),{get currentOptions(){return c.extend({},h)},removeMediaQueryListeners:g}}}(window,document,a),function(a,b,c){"use strict";c.Interpolation={},c.Interpolation.none=function(){return function(a){for(var b=(new c.Svg.Path).move(a[0],a[1]),d=3;d<a.length;d+=2)b.line(a[d-1],a[d]);return b}},c.Interpolation.simple=function(a){var b={divisor:2};a=c.extend({},b,a);var d=1/Math.max(1,a.divisor);return function(a){for(var b=(new c.Svg.Path).move(a[0],a[1]),e=2;e<a.length;e+=2){var f=a[e-2],g=a[e-1],h=a[e],i=a[e+1],j=(h-f)*d;b.curve(f+j,g,h-j,i,h,i)}return b}},c.Interpolation.cardinal=function(a){var b={tension:1};a=c.extend({},b,a);var d=Math.min(1,Math.max(0,a.tension)),e=1-d;return function(a){if(a.length<=4)return c.Interpolation.none()(a);for(var b,f=(new c.Svg.Path).move(a[0],a[1]),g=0,h=a.length;h-2*!b>g;g+=2){var i=[{x:+a[g-2],y:+a[g-1]},{x:+a[g],y:+a[g+1]},{x:+a[g+2],y:+a[g+3]},{x:+a[g+4],y:+a[g+5]}];b?g?h-4===g?i[3]={x:+a[0],y:+a[1]}:h-2===g&&(i[2]={x:+a[0],y:+a[1]},i[3]={x:+a[2],y:+a[3]}):i[0]={x:+a[h-2],y:+a[h-1]}:h-4===g?i[3]=i[2]:g||(i[0]={x:+a[g],y:+a[g+1]}),f.curve(d*(-i[0].x+6*i[1].x+i[2].x)/6+e*i[2].x,d*(-i[0].y+6*i[1].y+i[2].y)/6+e*i[2].y,d*(i[1].x+6*i[2].x-i[3].x)/6+e*i[2].x,d*(i[1].y+6*i[2].y-i[3].y)/6+e*i[2].y,i[2].x,i[2].y)}return f}}}(window,document,a),function(a,b,c){"use strict";c.EventEmitter=function(){function a(a,b){d[a]=d[a]||[],d[a].push(b)}function b(a,b){d[a]&&(b?(d[a].splice(d[a].indexOf(b),1),0===d[a].length&&delete d[a]):delete d[a])}function c(a,b){d[a]&&d[a].forEach(function(a){a(b)}),d["*"]&&d["*"].forEach(function(c){c(a,b)})}var d=[];return{addEventHandler:a,removeEventHandler:b,emit:c}}}(window,document,a),function(a,b,c){"use strict";function d(a){var b=[];if(a.length)for(var c=0;c<a.length;c++)b.push(a[c]);return b}function e(a,b){var d=b||this.prototype||c.Class,e=Object.create(d);c.Class.cloneDefinitions(e,a);var f=function(){var a,b=e.constructor||function(){};return a=this===c?Object.create(e):this,b.apply(a,Array.prototype.slice.call(arguments,0)),a};return f.prototype=e,f["super"]=d,f.extend=this.extend,f}function f(){var a=d(arguments),b=a[0];return a.splice(1,a.length-1).forEach(function(a){Object.getOwnPropertyNames(a).forEach(function(c){delete b[c],Object.defineProperty(b,c,Object.getOwnPropertyDescriptor(a,c))})}),b}c.Class={extend:e,cloneDefinitions:f}}(window,document,a),function(a,b,c){"use strict";function d(a,b,d){return a&&(this.data=a,this.eventEmitter.emit("data",{type:"update",data:this.data})),b&&(this.options=c.extend({},d?this.options:this.defaultOptions,b),this.initializeTimeoutId||(this.optionsProvider.removeMediaQueryListeners(),this.optionsProvider=c.optionsProvider(this.options,this.responsiveOptions,this.eventEmitter))),this.initializeTimeoutId||this.createChart(this.optionsProvider.currentOptions),this}function e(){return a.removeEventListener("resize",this.resizeListener),this.optionsProvider.removeMediaQueryListeners(),this}function f(a,b){return this.eventEmitter.addEventHandler(a,b),this}function g(a,b){return this.eventEmitter.removeEventHandler(a,b),this}function h(){a.addEventListener("resize",this.resizeListener),this.optionsProvider=c.optionsProvider(this.options,this.responsiveOptions,this.eventEmitter),this.eventEmitter.addEventHandler("optionsChanged",function(){this.update()}.bind(this)),this.options.plugins&&this.options.plugins.forEach(function(a){a instanceof Array?a[0](this,a[1]):a(this)}.bind(this)),this.eventEmitter.emit("data",{type:"initial",data:this.data}),this.createChart(this.optionsProvider.currentOptions),this.initializeTimeoutId=void 0}function i(b,d,e,f,g){this.container=c.querySelector(b),this.data=d,this.defaultOptions=e,this.options=f,this.responsiveOptions=g,this.eventEmitter=c.EventEmitter(),this.supportsForeignObject=c.Svg.isSupported("Extensibility"),this.supportsAnimations=c.Svg.isSupported("AnimationEventsAttribute"),this.resizeListener=function(){this.update()}.bind(this),this.container&&(this.container.__chartist__&&(this.container.__chartist__.initializeTimeoutId?a.clearTimeout(this.container.__chartist__.initializeTimeoutId):this.container.__chartist__.detach()),this.container.__chartist__=this),this.initializeTimeoutId=setTimeout(h.bind(this),0)}c.Base=c.Class.extend({constructor:i,optionsProvider:void 0,container:void 0,svg:void 0,eventEmitter:void 0,createChart:function(){throw new Error("Base chart type can't be instantiated!")},update:d,detach:e,on:f,off:g,version:c.version,supportsForeignObject:!1})}(window,document,a),function(a,b,c){"use strict";function d(a,d,e,f,g){a instanceof SVGElement?this._node=a:(this._node=b.createElementNS(y,a),"svg"===a&&this._node.setAttributeNS(z,c.xmlNs.qualifiedName,c.xmlNs.uri),d&&this.attr(d),e&&this.addClass(e),f&&(g&&f._node.firstChild?f._node.insertBefore(this._node,f._node.firstChild):f._node.appendChild(this._node)))}function e(a,b){return"string"==typeof a?b?this._node.getAttributeNS(b,a):this._node.getAttribute(a):(Object.keys(a).forEach(function(d){void 0!==a[d]&&(b?this._node.setAttributeNS(b,[c.xmlNs.prefix,":",d].join(""),a[d]):this._node.setAttribute(d,a[d]))}.bind(this)),this)}function f(a,b,d,e){return new c.Svg(a,b,d,this,e)}function g(){return this._node.parentNode instanceof SVGElement?new c.Svg(this._node.parentNode):null}function h(){for(var a=this._node;"svg"!==a.nodeName;)a=a.parentNode;return new c.Svg(a)}function i(a){var b=this._node.querySelector(a);return b?new c.Svg(b):null}function j(a){var b=this._node.querySelectorAll(a);return b.length?new c.Svg.List(b):null}function k(a,c,d,e){if("string"==typeof a){var f=b.createElement("div");f.innerHTML=a,a=f.firstChild}a.setAttribute("xmlns",A);var g=this.elem("foreignObject",c,d,e);return g._node.appendChild(a),g}function l(a){return this._node.appendChild(b.createTextNode(a)),this}function m(){for(;this._node.firstChild;)this._node.removeChild(this._node.firstChild);return this}function n(){return this._node.parentNode.removeChild(this._node),this.parent()}function o(a){return this._node.parentNode.replaceChild(a._node,this._node),a}function p(a,b){return b&&this._node.firstChild?this._node.insertBefore(a._node,this._node.firstChild):this._node.appendChild(a._node),this}function q(){return this._node.getAttribute("class")?this._node.getAttribute("class").trim().split(/\s+/):[]}function r(a){return this._node.setAttribute("class",this.classes(this._node).concat(a.trim().split(/\s+/)).filter(function(a,b,c){return c.indexOf(a)===b}).join(" ")),this}function s(a){var b=a.trim().split(/\s+/);return this._node.setAttribute("class",this.classes(this._node).filter(function(a){return-1===b.indexOf(a)}).join(" ")),this}function t(){return this._node.setAttribute("class",""),this}function u(){return this._node.clientHeight||Math.round(this._node.getBBox().height)||this._node.parentNode.clientHeight}function v(){return this._node.clientWidth||Math.round(this._node.getBBox().width)||this._node.parentNode.clientWidth}function w(a,b,d){return void 0===b&&(b=!0),Object.keys(a).forEach(function(e){function f(a,b){var f,g,h,i={};a.easing&&(h=a.easing instanceof Array?a.easing:c.Svg.Easing[a.easing],delete a.easing),a.begin=c.ensureUnit(a.begin,"ms"),a.dur=c.ensureUnit(a.dur,"ms"),h&&(a.calcMode="spline",a.keySplines=h.join(" "),a.keyTimes="0;1"),b&&(a.fill="freeze",i[e]=a.from,this.attr(i),g=c.stripUnit(a.begin||0),a.begin="indefinite"),f=this.elem("animate",c.extend({attributeName:e},a)),b&&setTimeout(function(){try{f._node.beginElement()}catch(b){i[e]=a.to,this.attr(i),f.remove()}}.bind(this),g),d&&f._node.addEventListener("beginEvent",function(){d.emit("animationBegin",{element:this,animate:f._node,params:a})}.bind(this)),f._node.addEventListener("endEvent",function(){d&&d.emit("animationEnd",{element:this,animate:f._node,params:a}),b&&(i[e]=a.to,this.attr(i),f.remove())}.bind(this))}a[e]instanceof Array?a[e].forEach(function(a){f.bind(this)(a,!1)}.bind(this)):f.bind(this)(a[e],b)}.bind(this)),this}function x(a){var b=this;this.svgElements=[];for(var d=0;d<a.length;d++)this.svgElements.push(new c.Svg(a[d]));Object.keys(c.Svg.prototype).filter(function(a){return-1===["constructor","parent","querySelector","querySelectorAll","replace","append","classes","height","width"].indexOf(a)}).forEach(function(a){b[a]=function(){var d=Array.prototype.slice.call(arguments,0);return b.svgElements.forEach(function(b){c.Svg.prototype[a].apply(b,d)}),b}})}var y="http://www.w3.org/2000/svg",z="http://www.w3.org/2000/xmlns/",A="http://www.w3.org/1999/xhtml";c.xmlNs={qualifiedName:"xmlns:ct",prefix:"ct",uri:"http://gionkunz.github.com/chartist-js/ct"},c.Svg=c.Class.extend({constructor:d,attr:e,elem:f,parent:g,root:h,querySelector:i,querySelectorAll:j,foreignObject:k,text:l,empty:m,remove:n,replace:o,append:p,classes:q,addClass:r,removeClass:s,removeAllClasses:t,height:u,width:v,animate:w}),c.Svg.isSupported=function(a){return b.implementation.hasFeature("www.http://w3.org/TR/SVG11/feature#"+a,"1.1")};var B={easeInSine:[.47,0,.745,.715],easeOutSine:[.39,.575,.565,1],easeInOutSine:[.445,.05,.55,.95],easeInQuad:[.55,.085,.68,.53],easeOutQuad:[.25,.46,.45,.94],easeInOutQuad:[.455,.03,.515,.955],easeInCubic:[.55,.055,.675,.19],easeOutCubic:[.215,.61,.355,1],easeInOutCubic:[.645,.045,.355,1],easeInQuart:[.895,.03,.685,.22],easeOutQuart:[.165,.84,.44,1],easeInOutQuart:[.77,0,.175,1],easeInQuint:[.755,.05,.855,.06],easeOutQuint:[.23,1,.32,1],easeInOutQuint:[.86,0,.07,1],easeInExpo:[.95,.05,.795,.035],easeOutExpo:[.19,1,.22,1],easeInOutExpo:[1,0,0,1],easeInCirc:[.6,.04,.98,.335],easeOutCirc:[.075,.82,.165,1],easeInOutCirc:[.785,.135,.15,.86],easeInBack:[.6,-.28,.735,.045],easeOutBack:[.175,.885,.32,1.275],easeInOutBack:[.68,-.55,.265,1.55]};c.Svg.Easing=B,c.Svg.List=c.Class.extend({constructor:x})}(window,document,a),function(a,b,c){"use strict";function d(a,b,d,e,f){d.splice(e,0,c.extend({command:f?a.toLowerCase():a.toUpperCase()},b))}function e(a,b){a.forEach(function(c,d){s[c.command.toLowerCase()].forEach(function(e,f){b(c,e,d,f,a)})})}function f(a,b){this.pathElements=[],this.pos=0,this.close=a,this.options=c.extend({},t,b)}function g(a){return void 0!==a?(this.pos=Math.max(0,Math.min(this.pathElements.length,a)),this):this.pos}function h(a){return this.pathElements.splice(this.pos,a),this}function i(a,b,c){return d("M",{x:+a,y:+b},this.pathElements,this.pos++,c),this}function j(a,b,c){return d("L",{x:+a,y:+b},this.pathElements,this.pos++,c),this}function k(a,b,c,e,f,g,h){return d("C",{x1:+a,y1:+b,x2:+c,y2:+e,x:+f,y:+g},this.pathElements,this.pos++,h),this}function l(a,b,c,e,f,g,h,i){return d("A",{rx:+a,ry:+b,xAr:+c,lAf:+e,sf:+f,x:+g,y:+h},this.pathElements,this.pos++,i),this}function m(a){var b=a.replace(/([A-Za-z])([0-9])/g,"$1 $2").replace(/([0-9])([A-Za-z])/g,"$1 $2").split(/[\s,]+/).reduce(function(a,b){return b.match(/[A-Za-z]/)&&a.push([]),a[a.length-1].push(b),a},[]);"Z"===b[b.length-1][0].toUpperCase()&&b.pop();var d=b.map(function(a){var b=a.shift(),d=s[b.toLowerCase()];return c.extend({command:b},d.reduce(function(b,c,d){return b[c]=+a[d],b},{}))}),e=[this.pos,0];return Array.prototype.push.apply(e,d),Array.prototype.splice.apply(this.pathElements,e),this.pos+=d.length,this}function n(){var a=Math.pow(10,this.options.accuracy);return this.pathElements.reduce(function(b,c){var d=s[c.command.toLowerCase()].map(function(b){return this.options.accuracy?Math.round(c[b]*a)/a:c[b]}.bind(this));return b+c.command+d.join(",")}.bind(this),"")+(this.close?"Z":"")}function o(a,b){return e(this.pathElements,function(c,d){c[d]*="x"===d[0]?a:b}),this}function p(a,b){return e(this.pathElements,function(c,d){c[d]+="x"===d[0]?a:b}),this}function q(a){return e(this.pathElements,function(b,c,d,e,f){var g=a(b,c,d,e,f);(g||0===g)&&(b[c]=g)}),this}function r(){var a=new c.Svg.Path(this.close);return a.pos=this.pos,a.pathElements=this.pathElements.slice().map(function(a){return c.extend({},a)}),a.options=c.extend({},this.options),a}var s={m:["x","y"],l:["x","y"],c:["x1","y1","x2","y2","x","y"],a:["rx","ry","xAr","lAf","sf","x","y"]},t={accuracy:3};c.Svg.Path=c.Class.extend({constructor:f,position:g,remove:h,move:i,line:j,curve:k,arc:l,scale:o,translate:p,transform:q,parse:m,stringify:n,clone:r}),c.Svg.Path.elementDescriptions=s}(window,document,a),function(a,b,c){"use strict";function d(a,b,c,d,f){this.units=a,this.counterUnits=a===e.x?e.y:e.x,this.chartRect=b,this.axisLength=b[a.rectEnd]-b[a.rectStart],this.gridOffset=b[a.rectOffset],this.transform=c,this.labelOffset=d,this.options=f}var e={x:{pos:"x",len:"width",dir:"horizontal",rectStart:"x1",rectEnd:"x2",rectOffset:"y2"},y:{pos:"y",len:"height",dir:"vertical",rectStart:"y2",rectEnd:"y1",rectOffset:"x1"}};c.Axis=c.Class.extend({constructor:d,projectValue:function(){throw new Error("Base axis can't be instantiated!")}}),c.Axis.units=e}(window,document,a),function(a,b,c){"use strict";function d(a,b,d,e,f){c.LinearScaleAxis["super"].constructor.call(this,a,b,d,e,f),this.bounds=c.getBounds(this.axisLength,f.highLow,f.scaleMinSpace,f.referenceValue)}function e(a){return{pos:this.axisLength*(a-this.bounds.min)/(this.bounds.range+this.bounds.step),len:c.projectLength(this.axisLength,this.bounds.step,this.bounds)}}c.LinearScaleAxis=c.Axis.extend({constructor:d,projectValue:e})}(window,document,a),function(a,b,c){"use strict";function d(a,b,d,e,f){c.StepAxis["super"].constructor.call(this,a,b,d,e,f),this.stepLength=this.axisLength/(f.stepCount-(f.stretch?1:0))}function e(a,b){return{pos:this.stepLength*b,len:this.stepLength}}c.StepAxis=c.Axis.extend({constructor:d,projectValue:e})}(window,document,a),function(a,b,c){"use strict";function d(a){var b=[],d=c.normalizeDataArray(c.getDataArray(this.data,a.reverseData),this.data.labels.length),e=c.normalizePadding(a.chartPadding,f.padding);this.svg=c.createSvg(this.container,a.width,a.height,a.classNames.chart);var g=c.createChartRect(this.svg,a,f.padding),h=c.getHighLow(d);h.high=+a.high||(0===a.high?0:h.high),h.low=+a.low||(0===a.low?0:h.low);var i=new c.StepAxis(c.Axis.units.x,g,function(a){return a.pos=g.x1+a.pos,a},{x:a.axisX.labelOffset.x,y:g.y1+a.axisX.labelOffset.y+(this.supportsForeignObject?5:20)},{stepCount:this.data.labels.length,stretch:a.fullWidth}),j=new c.LinearScaleAxis(c.Axis.units.y,g,function(a){return a.pos=g.y1-a.pos,a},{x:e.left+a.axisY.labelOffset.x+(this.supportsForeignObject?-10:0),y:a.axisY.labelOffset.y+(this.supportsForeignObject?-15:0)},{highLow:h,scaleMinSpace:a.axisY.scaleMinSpace}),k=this.svg.elem("g").addClass(a.classNames.labelGroup),l=this.svg.elem("g").addClass(a.classNames.gridGroup);c.createAxis(i,this.data.labels,g,l,k,this.supportsForeignObject,a,this.eventEmitter),c.createAxis(j,j.bounds.values,g,l,k,this.supportsForeignObject,a,this.eventEmitter),this.data.series.forEach(function(e,f){b[f]=this.svg.elem("g"),b[f].attr({"series-name":e.name,meta:c.serialize(e.meta)},c.xmlNs.uri),b[f].addClass([a.classNames.series,e.className||a.classNames.series+"-"+c.alphaNumerate(f)].join(" "));var h=[];if(d[f].forEach(function(k,l){var m={x:g.x1+i.projectValue(k,l,d[f]).pos,y:g.y1-j.projectValue(k,l,d[f]).pos};if(h.push(m.x,m.y),a.showPoint){var n=b[f].elem("line",{x1:m.x,y1:m.y,x2:m.x+.01,y2:m.y},a.classNames.point).attr({value:k,meta:c.getMetaData(e,l)},c.xmlNs.uri);this.eventEmitter.emit("draw",{type:"point",value:k,index:l,group:b[f],element:n,x:m.x,y:m.y})}}.bind(this)),a.showLine||a.showArea){var k="function"==typeof a.lineSmooth?a.lineSmooth:a.lineSmooth?c.Interpolation.cardinal():c.Interpolation.none(),l=k(h);if(a.showLine){var m=b[f].elem("path",{d:l.stringify()},a.classNames.line,!0).attr({values:d[f]},c.xmlNs.uri);this.eventEmitter.emit("draw",{type:"line",values:d[f],path:l.clone(),chartRect:g,index:f,group:b[f],element:m})}if(a.showArea){var n=Math.max(Math.min(a.areaBase,j.bounds.max),j.bounds.min),o=g.y1-j.projectValue(n).pos,p=l.clone();p.position(0).remove(1).move(g.x1,o).line(h[0],h[1]).position(p.pathElements.length).line(h[h.length-2],o);var q=b[f].elem("path",{d:p.stringify()},a.classNames.area,!0).attr({values:d[f]},c.xmlNs.uri);this.eventEmitter.emit("draw",{type:"area",values:d[f],path:p.clone(),chartRect:g,index:f,group:b[f],element:q})}}}.bind(this)),this.eventEmitter.emit("created",{bounds:j.bounds,chartRect:g,axisX:i,axisY:j,svg:this.svg,options:a})}function e(a,b,d,e){c.Line["super"].constructor.call(this,a,b,f,c.extend({},f,d),e)}var f={axisX:{offset:30,labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:c.noop},axisY:{offset:40,labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:c.noop,scaleMinSpace:20},width:void 0,height:void 0,showLine:!0,showPoint:!0,showArea:!1,areaBase:0,lineSmooth:!0,low:void 0,high:void 0,chartPadding:5,fullWidth:!1,reverseData:!1,classNames:{chart:"ct-chart-line",label:"ct-label",labelGroup:"ct-labels",series:"ct-series",line:"ct-line",point:"ct-point",area:"ct-area",grid:"ct-grid",gridGroup:"ct-grids",vertical:"ct-vertical",horizontal:"ct-horizontal"}};c.Line=c.Base.extend({constructor:e,createChart:d})}(window,document,a),function(a,b,c){"use strict";function d(a){var b,d=[],e=c.normalizeDataArray(c.getDataArray(this.data,a.reverseData),this.data.labels.length),g=c.normalizePadding(a.chartPadding,f.padding);if(this.svg=c.createSvg(this.container,a.width,a.height,a.classNames.chart),a.stackBars){var h=c.serialMap(e,function(){return Array.prototype.slice.call(arguments).reduce(c.sum,0)});b=c.getHighLow([h])}else b=c.getHighLow(e);b.high=+a.high||(0===a.high?0:b.high),b.low=+a.low||(0===a.low?0:b.low);var i,j,k,l,m=c.createChartRect(this.svg,a,f.padding);a.horizontalBars?(j=l=new c.StepAxis(c.Axis.units.y,m,function(a){return a.pos=m.y1-a.pos,a},{x:g.left+a.axisY.labelOffset.x+(this.supportsForeignObject?-10:0),y:a.axisY.labelOffset.y-m.height()/this.data.labels.length},{stepCount:this.data.labels.length,stretch:a.fullHeight}),i=k=new c.LinearScaleAxis(c.Axis.units.x,m,function(a){return a.pos=m.x1+a.pos,a},{x:a.axisX.labelOffset.x,y:m.y1+a.axisX.labelOffset.y+(this.supportsForeignObject?5:20)},{highLow:b,scaleMinSpace:a.axisX.scaleMinSpace,referenceValue:0})):(j=k=new c.StepAxis(c.Axis.units.x,m,function(a){return a.pos=m.x1+a.pos,a},{x:a.axisX.labelOffset.x,y:m.y1+a.axisX.labelOffset.y+(this.supportsForeignObject?5:20)},{stepCount:this.data.labels.length}),i=l=new c.LinearScaleAxis(c.Axis.units.y,m,function(a){return a.pos=m.y1-a.pos,a},{x:g.left+a.axisY.labelOffset.x+(this.supportsForeignObject?-10:0),y:a.axisY.labelOffset.y+(this.supportsForeignObject?-15:0)},{highLow:b,scaleMinSpace:a.axisY.scaleMinSpace,referenceValue:0}));var n=this.svg.elem("g").addClass(a.classNames.labelGroup),o=this.svg.elem("g").addClass(a.classNames.gridGroup),p=a.horizontalBars?m.x1+i.projectValue(0).pos:m.y1-i.projectValue(0).pos,q=[];c.createAxis(j,this.data.labels,m,o,n,this.supportsForeignObject,a,this.eventEmitter),c.createAxis(i,i.bounds.values,m,o,n,this.supportsForeignObject,a,this.eventEmitter),this.data.series.forEach(function(b,f){var g=f-(this.data.series.length-1)/2,h=m[j.units.len]()/e[f].length/2;d[f]=this.svg.elem("g"),d[f].attr({"series-name":b.name,meta:c.serialize(b.meta)},c.xmlNs.uri),d[f].addClass([a.classNames.series,b.className||a.classNames.series+"-"+c.alphaNumerate(f)].join(" ")),e[f].forEach(function(k,l){var n,o,r={x:m.x1+(a.horizontalBars?i:j).projectValue(k,l,e[f]).pos,y:m.y1-(a.horizontalBars?j:i).projectValue(k,l,e[f]).pos};r[j.units.pos]+=h*(a.horizontalBars?-1:1),r[j.units.pos]+=a.stackBars?0:g*a.seriesBarDistance*(a.horizontalBars?-1:1),o=q[l]||p,q[l]=o-(p-r[j.counterUnits.pos]);var s={};s[j.units.pos+"1"]=r[j.units.pos],s[j.units.pos+"2"]=r[j.units.pos],s[j.counterUnits.pos+"1"]=a.stackBars?o:p,s[j.counterUnits.pos+"2"]=a.stackBars?q[l]:r[j.counterUnits.pos],n=d[f].elem("line",s,a.classNames.bar).attr({value:k,meta:c.getMetaData(b,l)},c.xmlNs.uri),this.eventEmitter.emit("draw",c.extend({type:"bar",value:k,index:l,chartRect:m,group:d[f],element:n},s))}.bind(this))}.bind(this)),this.eventEmitter.emit("created",{bounds:i.bounds,chartRect:m,axisX:k,axisY:l,svg:this.svg,options:a})}function e(a,b,d,e){c.Bar["super"].constructor.call(this,a,b,f,c.extend({},f,d),e)}var f={axisX:{offset:30,labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:c.noop,scaleMinSpace:40},axisY:{offset:40,labelOffset:{x:0,y:0},showLabel:!0,showGrid:!0,labelInterpolationFnc:c.noop,scaleMinSpace:20},width:void 0,height:void 0,high:void 0,low:void 0,chartPadding:5,seriesBarDistance:15,stackBars:!1,horizontalBars:!1,reverseData:!1,classNames:{chart:"ct-chart-bar",label:"ct-label",labelGroup:"ct-labels",series:"ct-series",bar:"ct-bar",grid:"ct-grid",gridGroup:"ct-grids",vertical:"ct-vertical",horizontal:"ct-horizontal"}};c.Bar=c.Base.extend({constructor:e,createChart:d})}(window,document,a),function(a,b,c){"use strict";function d(a,b,c){var d=b.x>a.x;return d&&"explode"===c||!d&&"implode"===c?"start":d&&"implode"===c||!d&&"explode"===c?"end":"middle"}function e(a){var b,e,f,h,i=[],j=a.startAngle,k=c.getDataArray(this.data,a.reverseData);this.svg=c.createSvg(this.container,a.width,a.height,a.classNames.chart),b=c.createChartRect(this.svg,a,g.padding),e=Math.min(b.width()/2,b.height()/2),h=a.total||k.reduce(function(a,b){return a+b},0),e-=a.donut?a.donutWidth/2:0,f=a.donut?e:e/2,f+=a.labelOffset;for(var l={x:b.x1+b.width()/2,y:b.y2+b.height()/2},m=1===this.data.series.filter(function(a){return 0!==a}).length,n=0;n<this.data.series.length;n++){i[n]=this.svg.elem("g",null,null,!0),this.data.series[n].name&&i[n].attr({"series-name":this.data.series[n].name,meta:c.serialize(this.data.series[n].meta)},c.xmlNs.uri),i[n].addClass([a.classNames.series,this.data.series[n].className||a.classNames.series+"-"+c.alphaNumerate(n)].join(" "));var o=j+k[n]/h*360;o-j===360&&(o-=.01);var p=c.polarToCartesian(l.x,l.y,e,j-(0===n||m?0:.2)),q=c.polarToCartesian(l.x,l.y,e,o),r=new c.Svg.Path(!a.donut).move(q.x,q.y).arc(e,e,0,o-j>180,0,p.x,p.y);a.donut||r.line(l.x,l.y);var s=i[n].elem("path",{d:r.stringify()},a.classNames.slice+(a.donut?" "+a.classNames.donut:""));if(s.attr({value:k[n]},c.xmlNs.uri),a.donut&&s.attr({style:"stroke-width: "+ +a.donutWidth+"px"}),this.eventEmitter.emit("draw",{type:"slice",value:k[n],totalDataSum:h,index:n,group:i[n],element:s,path:r.clone(),center:l,radius:e,startAngle:j,endAngle:o}),a.showLabel){var t=c.polarToCartesian(l.x,l.y,f,j+(o-j)/2),u=a.labelInterpolationFnc(this.data.labels?this.data.labels[n]:k[n],n),v=i[n].elem("text",{dx:t.x,dy:t.y,"text-anchor":d(l,t,a.labelDirection)},a.classNames.label).text(""+u);this.eventEmitter.emit("draw",{type:"label",index:n,group:i[n],element:v,text:""+u,x:t.x,y:t.y})}j=o}this.eventEmitter.emit("created",{chartRect:b,svg:this.svg,options:a})}function f(a,b,d,e){c.Pie["super"].constructor.call(this,a,b,g,c.extend({},g,d),e)}var g={width:void 0,height:void 0,chartPadding:5,classNames:{chart:"ct-chart-pie",series:"ct-series",slice:"ct-slice",donut:"ct-donut",label:"ct-label"},startAngle:0,total:void 0,donut:!1,donutWidth:60,showLabel:!0,labelOffset:0,labelInterpolationFnc:c.noop,labelDirection:"neutral",reverseData:!1};c.Pie=c.Base.extend({constructor:f,createChart:e,determineAnchorPosition:d})}(window,document,a),a});
//# sourceMappingURL=chartist.min.js.map