$(document).ready(function() {

    let form = [];
    let count = 0;

    if ($('form[action="reset"]').is(':visible')) {
        swal({
                title: "Você tem certeza?",
                text: `Você estará resetando todo o seu site, zerando todos os dados cadastrados e personalizados`,
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Sim, eu tenho",
                cancelButtonText: "Não, cancele",
                closeOnConfirm: true,
                closeOnCancel: false
            },
            function(isConfirm) {
                if (!isConfirm) {
                    window.history.go(-1);
                }
            });

        $('form[action="reset"]').submit(function(e) {
            e.preventDefault();

            let url = $(this).attr('action');
            let data = $(this).serialize();
            let elem = this;

            $.ajax({
                type: "POST",
                url: url,
                data: data,
                success: function(response) {
                    if (response != '') {
                        swal("Ooops tem um erro", response, "error");
                        return false;
                    }
                    count++;

                    $(elem).slideUp();
                    $(elem).removeClass('active');

                    setTimeout(() => {
                        $(form[count]).slideDown();
                        $(form[count]).addClass('active');
                    }, 1000);
                }
            });
        });
    }

    $('.install form').each(function(index, element) {
        form.push(this);
    });

    $('.install form:not(.reset)').submit(function(e) {
        e.preventDefault();

        let url = $(this).attr('action');
        let data = $(this).serialize();
        let elem = this;

        if ($('form[action="admin/persist"] input[name="password"]').is(':visible')) {
            if ($('form[action="admin/persist"] input[name="password"]').val() != $('input[name="confirmPassword"]').val()) {
                swal("Ooops tem um erro", "A senha não são compativeis, por favor tente novamente", "error");
                return false;
            }
        }

        $.ajax({
            type: "POST",
            url: url,
            data: data,
            success: function(response) {
                count++;
                if (count == form.length) {
                    window.location.reload();
                    return false;
                }

                $(elem).slideUp();
                $(elem).removeClass('active');

                setTimeout(() => {
                    $(form[count]).slideDown();
                    $(form[count]).addClass('active');
                }, 1000);
            }
        });
    });

    // Visualização de senha no login

    let shadowActive;

    $('.eyes').click(function(e) {
        e.preventDefault();

        if (shadowActive != true) {
            $(this).siblings('input').attr('type', 'text');
            $(this).html(`
				<svg class="svg-inline--fa fa-eye fa-w-18" aria-hidden="true" focusable="false" data-prefix="fa" data-icon="eye" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512" data-fa-i2svg=""><path fill="currentColor" d="M572.52 241.4C518.29 135.59 410.93 64 288 64S57.68 135.64 3.48 241.41a32.35 32.35 0 0 0 0 29.19C57.71 376.41 165.07 448 288 448s230.32-71.64 284.52-177.41a32.35 32.35 0 0 0 0-29.19zM288 400a144 144 0 1 1 144-144 143.93 143.93 0 0 1-144 144zm0-240a95.31 95.31 0 0 0-25.31 3.79 47.85 47.85 0 0 1-66.9 66.9A95.78 95.78 0 1 0 288 160z"></path></svg>
				`);
            shadowActive = true;
            return;
        }

        $(this).siblings('input').attr('type', 'password');
        $(this).html(`
            <svg class="svg-inline--fa fa-eye-slash fa-w-20" aria-hidden="true" focusable="false" data-prefix="far" data-icon="eye-slash" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512" data-fa-i2svg=""><path fill="currentColor" d="M634 471L36 3.51A16 16 0 0 0 13.51 6l-10 12.49A16 16 0 0 0 6 41l598 467.49a16 16 0 0 0 22.49-2.49l10-12.49A16 16 0 0 0 634 471zM296.79 146.47l134.79 105.38C429.36 191.91 380.48 144 320 144a112.26 112.26 0 0 0-23.21 2.47zm46.42 219.07L208.42 260.16C210.65 320.09 259.53 368 320 368a113 113 0 0 0 23.21-2.46zM320 112c98.65 0 189.09 55 237.93 144a285.53 285.53 0 0 1-44 60.2l37.74 29.5a333.7 333.7 0 0 0 52.9-75.11 32.35 32.35 0 0 0 0-29.19C550.29 135.59 442.93 64 320 64c-36.7 0-71.71 7-104.63 18.81l46.41 36.29c18.94-4.3 38.34-7.1 58.22-7.1zm0 288c-98.65 0-189.08-55-237.93-144a285.47 285.47 0 0 1 44.05-60.19l-37.74-29.5a333.6 333.6 0 0 0-52.89 75.1 32.35 32.35 0 0 0 0 29.19C89.72 376.41 197.08 448 320 448c36.7 0 71.71-7.05 104.63-18.81l-46.41-36.28C359.28 397.2 339.89 400 320 400z"></path></svg>
			`);
        shadowActive = false;
    });

});