<?php 

use Template\Entity\Color;

require __DIR__ . '/../../../../vendor/autoload.php';

header("Content-type: text/css; charset: UTF-8");

$entityManager = require __DIR__ . '/../../../../config/dependencies.php';
try {
    $repositoryColor = $entityManager->getRepository(Color::class);
    $color = $repositoryColor->findOneBy(['id' => 1]);
} catch (\Throwable $th) {
    $color = null;
}
?>

#main {
    padding-left: 240px;
    height: calc(100vh - 134px);
    position: relative;
    overflow: auto;
}

#header nav {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    padding: 7px;
    position: relative;
}

#header nav::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    background-color: #fff;
    opacity: .7;
    width: 100%;
    height: 100%;
}

#header img {
    width: 100%;
    height: 40px;
    object-fit: contain;
    object-position: right;
    padding: 0;
}

#header nav .brand-logo {
    right: 0px !important;
    transform: none !important;
    padding: 0 !important;
}

#header .sidebar-collapse {
    position: relative !important;
    top: 0 !important;
    left: 0 !important;
    background-color: transparent !important;
    box-shadow: none !important;
}

@media(min-width: 993px) {
    #header nav {
        padding: 0 2px;
    }
    #header img {
        height: 40px;
    }
    #header nav .brand-logo {
        padding: 10px !important;
    }
}

.side-nav {
    height: calc(100vh - 60px) !important;
}

#slide-out li a i {
    margin-right: 5px !important;
}

.ps-scrollbar-y-rail {
    height: 0 !important;
    position: relative;
    overflow: hidden;
}

.collapsible .bold.active .collapsible-header {
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
}

.collapsible .bold.active a {
    color: #777 !important;
}

.profile-btn {
    margin-top: 8px !important;
    height: auto !important;
    line-height: 1.5em !important;
}

footer .container {
    position: relative;
    font-size: .8em;
    display: flex;
    align-items: center;
    justify-content: space-between;
    flex-wrap: nowrap;
}

footer {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    position: relative;
}

footer::before {
    content: '';
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, .7);
    position: absolute;
    left: 0;
    top: 0;
}

footer img {
    width: auto;
    height: 20px;
    object-fit: contain;
    position: relative;
    margin-left: 10px;
    top: 5px;
}

footer a {
    font-size: .8em;
    color: #fff;
    text-transform: uppercase;
    position: relative;
    display: flex;
    align-items: center;
    flex-wrap: nowrap;
    justify-content: center;
    font-weight: bold;
    top: 2px;
}

.painel .card p {
    font-weight: bold;
    font-size: 1.25em;
}

.painel h4 {
    font-size: 2em;
}

#main {
    padding-left: 0 !important;
}

@media(min-width: 993px) {
    #main {
        padding-left: 240px !important;
    }
}


/*-------- Pagina de login --------*/

.login {
    background-image: url(../../../admin/images/user-bg.jpg);
    background-position: center;
    background-size: cover;
    display: flex;
    align-items: center;
    justify-content: center;
    min-height: 100vh;
    width: 100%;
    padding: 40px;
}

.login .fundo {
    width: 100%;
    height: 100vh;
    position: absolute;
    top: 0;
    left: 0;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    opacity: .7;
}

.login .box {
    position: relative;
    width: 100%;
    max-width: 450px;
    background-color: #ccc;
}

.login figure {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    padding: 20px;
    width: 100%;
    float: left;
    position: relative;
}

.login::before {
    content: '';
    background-color: #fff;
    width: 100%;
    height: 100%;
    opacity: .7;
    position: absolute;
    top: 0;
    left: 0;
}

.login img {
    width: 100%;
    height: 120px;
    padding: 20px;
    object-fit: contain;
    margin-bottom: -6px !important;
    filter: brightness(1000%);
}

.login fieldset {
    padding: 20px 40px !important;
    width: 100% !important;
    float: left;
}

.login h1 {
    text-align: center;
    font-weight: bold;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    text-transform: uppercase;
    font-size: 1.5em;
    margin: 0;
}

.login p {
    text-align: center;
    color: #000;
    margin: 0;
    line-height: 1.25em;
    font-size: .8em;
}


.login .ck p {
    text-align: left !important;
}

.login label[for="user"],
.login label[for="password"] {
    font-size: 1em;
    margin-top: 10px !important;
    width: 100%;
    float: left;
    color: #000;
}

.login input {
    margin: 0 !important;
    margin-top: 5px !important;
    margin-bottom: 5px !important;
    background-color: white !important;
    color: #999999 !important;
    padding-left: 1em !important;
    width: calc(100% - 1em) !important;
    border: none !important;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    border-radius: 5px !important;
    font-size: .9em !important;
}

.login input::placeholder {
    color: #666;
    font-size: 1em !important;
}

.login .flex {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin: 10px 0;
}

.login p label {
    font-size: 1em;
    font-weight: bold;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.login .flex a {
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    font-size: .8em;
}

.login .flex [type="checkbox"]+label {
    padding-left: 25px !important;
}

.login .btn {
    width: 100%;
    height: 3em;
    line-height: 3em;
    box-shadow: none !important;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
    border-radius: 5px;
    margin-top: 10px;
    margin-bottom: 20px;
}

.login .center a,
.login .left a {
    width: 100%;
    float: left;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    margin-top: 5px;
    font-weight: bold;
    text-decoration: underline;
    font-size: .9em;
}


/*-------- Controller Brand --------*/

.logo {
    padding: 20px 5%;
}

.logo h2 {
    font-size: 1.75em;
    margin-top: 0;
    font-weight: bold;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.logo form {
    border: 1px solid #ccc;
    padding: 20px;
    width: 100%;
    float: left;
}

.logo h3 {
    font-size: 1.5em;
    margin-top: 0;
    color: #666;
    font-weight: bold;
}

.logo p {
    margin: 0;
}

.logo .dropify-wrapper {
    width: 200px !important;
    height: 150px !important;
    text-align: center !important;
    margin: 20px auto;
    padding: 0 !important;
}

.logo .dropify-wrapper button {
    display: none !important;
}

.logo .dropify-preview,
.logo .dropify-preview img {
    background-color: #fff !important;
}

.logo .dropify-preview img {
    width: 100% !important;
    height: auto !important;
    object-fit: contain !important;
    padding: 10px !important;
}

.logo .dropify-wrapper .dropify-message p {
    text-align: center;
    padding: 0 10px;
}

.logo .dropify-wrapper.touch-fallback .dropify-preview .dropify-infos {
    background-color: #ccc;
    padding: 10px;
}

.logo form .btn {
    width: 100%;
    margin-bottom: 10px;
    line-height: 3em;
    height: 3em;
    background-color: #dd3341 !important;
    text-transform: none;
}

.logo form .center button.btn {
    background-color: #40cd28 !important;
}

.logo form .center {
    padding: 0 !important;
}

.logo form:nth-of-type(2) {
    margin-top: 40px;
}

.logo form:nth-of-type(2) .dropify-preview,
.logo form:nth-of-type(2) .dropify-preview img {
    background-color: #fff !important;
}

.logo .card {
    margin-bottom: 0 !important;
    box-shadow: none;
}

.logo .card .card-content {
    padding: 10px 20px;
    display: flex;
    align-items: center;
    border: 1px solid #03a9f4 !important;
    color: #03a9f4 !important;
}

.logo .orange {
    background-color: #fff !important;
}

.logo .card p {
    margin: 0;
    position: relative;
    top: -2px;
    line-height: 1.25em;
    font-size: .8em;
}

.logo .close {
    position: absolute;
    top: 4px !important;
    color: #03a9f4 !important;
}

.logo .color {
    width: 100%;
    min-width: 300px;
    height: 200px;
    float: left;
    display: flex;
    align-items: center;
    justify-content: center;
}

.logo hgroup {
    padding: 10px;
}

.logo .color input {
    width: 100px;
    height: 100px;
    margin: 0 !important;
}

@media(min-width: 601px) {
    .logo .dropify-wrapper {
        float: left;
        margin-bottom: 0 !important;
    }
    .logo .color {
        width: 200px;
    }
    .logo form .center {
        float: left;
        width: min-content !important;
        height: 200px;
        display: flex;
        align-content: center;
        flex-wrap: wrap;
        padding-left: 20px !important;
        margin: 0;
        margin-bottom: -20px;
    }
    .logo form .btn {
        padding: 0 2em;
        width: max-content;
    }
}


/*-------- Banner Principal --------*/

.banner h2 {
    font-size: 2em;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    font-weight: bold;
}

.banner .file-field {
    width: inherit !important;
    padding: 0 !important;
    position: absolute !important;
    margin: 0 !important;
    top: 10px;
    right: 10px;
    cursor: pointer;
}

.banner .file-field .btn {
    background-color: rgba(255, 255, 255, .3) !important;
    border-radius: 0;
    width: 50px;
    height: 50px;
    padding: 0 !important;
    display: flex;
    align-items: center;
    justify-content: center;
}

.banner .col.s12.center .btn {
    margin-top: 20px;
    padding: 0 4em;
    height: 3em;
    line-height: 3em;
    box-shadow: none !important;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
    border-radius: 30px;
}

.head {
    padding: 40px 0;
    margin-bottom: 0 !important;
    display: flex;
    align-items: center;
    justify-content: center;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    position: relative;
    overflow: hidden;
}

.head .action {
    position: relative;
    width: 100%;
    float: left;
    display: flex;
    justify-content: center;
    padding: 0;
}

.head input {
    transition: all .5s;
    opacity: 0;
    position: absolute;
    width: 250px !important;
    height: 30px !important;
    margin: 0 auto !important;
    bottom: -50px;
    background-color: white !important;
    color: #666 !important;
    padding-left: 1em !important;
    border: 4px solid rgba(0, 0, 0, .3) !important;
}

.head input::placeholder {
    color: #666;
}

.head .action:hover input {
    opacity: 1;
}

.head img {
    position: absolute;
    z-index: -1;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.head div {
    width: 100%;
    padding: 7%;
    max-width: 1200px;
    position: relative;
}

.head::before {
    content: '';
    width: 100%;
    height: 100%;
    position: absolute;
    top: 0;
    left: 0;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    opacity: .9;
}

.head h1 {
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    font-size: 2em;
    font-weight: bold;
    color: white;
    margin-bottom: 0;
}

.head p {
    text-align: center;
    font-size: 1em;
    color: white;
    margin-top: 0;
}

.head .btn {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    border-radius: 30px;
    padding: 0 2em !important;
    height: 3rem;
    line-height: 3rem;
    text-transform: none !important;
    box-shadow: none !important;
}

@media(min-width: 993px) {
    .head {
        padding: 0;
        min-height: calc(100vh - 100px);
    }
    .head h1 {
        font-size: 2.5em;
    }
    .head p {
        font-size: 1.25em;
    }
}


/*-------- Sobre --------*/

.company h1 {
    font-size: 2em;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    font-weight: bold;
}

.company .file-field {
    width: inherit !important;
    padding: 0 !important;
    position: absolute !important;
    margin: 0 !important;
    top: 10px;
    right: 10px;
    cursor: pointer;
}

.company .file-field .btn {
    background-color: rgba(255, 255, 255, .3) !important;
    border-radius: 0;
    width: 50px;
    height: 50px;
    padding: 0 !important;
    display: flex;
    align-items: center;
    justify-content: center;
}

.company .col.s12.center .btn {
    margin-top: 20px;
    padding: 0 4em;
    height: 3em;
    line-height: 3em;
    box-shadow: none !important;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
    border-radius: 30px;
}

.sobre {
    padding: 60px 10%;
    position: relative;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    min-height: 350px;
    display: flex !important;
    align-items: center;
}

.sobre img {
    position: absolute;
    z-index: -1;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.sobre::before {
    content: '';
    width: 100%;
    height: 100%;
    position: absolute;
    top: 0;
    left: 0;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    opacity: .9;
}

.sobre article {
    position: relative;
    z-index: 1;
    max-width: 500px;
}

.sobre h2 {
    font-size: 2em;
    color: white;
    margin: 0;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
}

.sobre p {
    color: white;
}

.sobre .btn {
    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;
    border-radius: 5px;
    font-weight: bold;
    padding: 0 2em;
    line-height: 2.9em;
    height: 3em;
    box-shadow: none !important;
    text-transform: none;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
}

.sobre .inline {
    padding: 0 !important;
}

.choose {
    padding: 5%;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
}

.choose h2 {
    font-size: 1.5em;
    text-transform: uppercase;
    margin: 0;
    font-weight: bold;
    color: #4b4b4b;
}

.choose hr {
    border: none;
    width: 50px;
    height: 2px;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.choose .col {
    margin-top: 2em;
}

.choose svg {
    width: 70px !important;
    height: 70px;
    padding: 15px;
    border-radius: 50%;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    color: white;
    border: 2px solid transparent;
    transition: all 1s;
}

.choose h3 {
    font-size: 1.1em;
    margin: 0;
    margin-top: 20px;
    color: #4b4b4b;
    font-weight: bold;
}

.choose p {
    line-height: 1.5em;
    font-size: .9em;
    text-align: center;
}

.choose .col:hover svg {
    animation: espansao .3s;
    animation-fill-mode: forwards;
    -webkit-animation: espansao .3s;
    -webkit-animation-fill-mode: forwards;
}

@keyframes espansao {
    0% {
        box-shadow: 0 0 0 5px <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    }
    100% {
        background-color: #fff;
        border-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
        color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    }
}


/*-------- Pagina de Contato --------*/

.contact h2 {
    font-size: 2em;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    font-weight: bold;
}

.contact .file-field {
    width: inherit !important;
    padding: 0 !important;
    position: absolute !important;
    margin: 0 !important;
    top: 10px;
    right: 10px;
    cursor: pointer;
}

.contact .file-field .btn {
    background-color: rgba(255, 255, 255, .3) !important;
    border-radius: 0;
    width: 50px;
    height: 50px;
    padding: 0 !important;
    display: flex;
    align-items: center;
    justify-content: center;
}

.contact .col.s12.center .btn {
    margin-top: 20px;
    padding: 0 4em;
    height: 3em;
    line-height: 3em;
    box-shadow: none !important;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
    border-radius: 30px;
}

.form {
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    margin-bottom: 0 !important;
    position: relative;
}

.form img {
    position: absolute;
    z-index: -1;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.form .content {
    padding: 5% !important;
    background-color: rgba(0, 0, 0, .5);
    min-height: 500px !important;
}

@media(min-width: 601px) {
    .form .content {
        max-width: 50%;
    }
}

.form .m6 {
    display: flex;
    align-items: center;
    justify-content: center;
}

.form h3 {
    font-size: 1.25em;
    font-weight: bold;
    color: white;
    margin: 0;
    font-family: 'Open Sans Bold', Tahoma, Geneva, Verdana, sans-serif;
}

.form h2 {
    font-size: 1.5em;
    font-weight: bold;
    color: white;
    margin: 0 auto;
    max-width: 400px;
    margin-bottom: 20px;
    font-family: 'Open Sans Bold', Tahoma, Geneva, Verdana, sans-serif;
}

.form input {
    padding-left: 1em !important;
    width: calc(100% - 1em) !important;
}

.form textarea {
    padding: 1em !important;
    width: calc(100% - 2em) !important;
}

.form input,
.form textarea {
    background-color: #E6E7E8 !important;
    border: none !important;
    border-radius: 5px !important;
}

.form input::placeholder,
.form textarea::placeholder {
    color: #666;
}

.form .formu {
    margin: 0 auto;
    margin-top: 1em;
    max-width: 700px;
}

.form .btn-large {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    text-transform: none !important;
    border-radius: 5px;
    box-shadow: none;
    font-weight: bold;
}


/*-------- Chamada simulador --------*/

.simulator h2 {
    font-size: 2em;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    font-weight: bold;
}

.simulator .file-field {
    width: inherit !important;
    padding: 0 !important;
    position: absolute !important;
    margin: 0 !important;
    top: 10px;
    right: 10px;
    cursor: pointer;
}

.simulator .file-field .btn {
    background-color: rgba(255, 255, 255, .3) !important;
    border-radius: 0;
    width: 50px;
    height: 50px;
    padding: 0 !important;
    display: flex;
    align-items: center;
    justify-content: center;
}

.simulator .col.s12.center .btn {
    margin-top: 20px;
    padding: 0 4em;
    height: 3em;
    line-height: 3em;
    box-shadow: none !important;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
    border-radius: 30px;
}

.action {
    padding: 120px 60px;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    position: relative;
}

.action img {
    position: absolute;
    z-index: -1;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.action::before {
    content: '';
    width: 100%;
    height: 100%;
    top: 0;
    left: 0;
    position: absolute;
    background-color: rgba(0, 0, 0, .3);
}

.action h2 {
    font-size: 2em;
    color: white;
    text-transform: uppercase;
    margin: 0;
    position: relative;
}

.action strong {
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.action .btn {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    margin-top: 20px;
    padding: 0 3em;
    font-size: .8em;
    box-shadow: none;
    font-weight: bold;
    height: 4em;
    line-height: 4em;
    transition: all 1s;
}

.action .btn:hover {
    animation: botao .3s;
    animation-fill-mode: forwards;
    -webkit-animation: botao .3s;
    -webkit-animation-fill-mode: forwards;
}

@keyframes botao {
    0% {
        box-shadow: 0 0 0 5px <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    }
    100% {
        background-color: transparent;
        border: 1px solid #fff;
        color: #fff;
        box-shadow: none;
    }
}


/*-------- CHamada para Serviços --------*/

.service h2 {
    font-size: 2em;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    font-weight: bold;
}

.service .col.s12.center .btn {
    margin-top: 20px;
    padding: 0 4em;
    height: 3em;
    line-height: 3em;
    box-shadow: none !important;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
    border-radius: 30px;
}

.areas {
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    padding: 5%;
}

.areas h2 {
    font-family: 'Open Sans Bold', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    font-size: 2em;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.areas h3 {
    margin: 5px 0;
    font-size: 1.25em;
    color: #333;
}

.areas hr {
    width: 150px;
    height: 2px;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.areas .col {
    margin-top: 2em;
    transition: all .5s;
}

.areas article {
    border: 1px solid <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    padding: 20px 10px;
    border-radius: 10px;
    min-height: 250px !important;
    display: flex;
    align-items: center;
    position: relative;
    transition: all .5s;
}

.areas .fundo {
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    z-index: 0;
    border-radius: 10px;
    transition: all .5s;
}

.areas hgroup {
    position: relative;
    z-index: 1;
    width: 100%;
    text-align: center;
}

.areas img {
    border-radius: 10px;
    opacity: .3;
    width: 100%;
    height: 250px;
    object-fit: cover;
    position: absolute;
    top: 0;
    left: 0;
    z-index: -1;
    transition: all .5s;
}

.areas h4 {
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    font-family: 'Open Sans Bold', Tahoma, Geneva, Verdana, sans-serif;
    font-size: 1.25em;
    text-transform: uppercase;
    margin-top: 0;
    transition: all .5s;
}

.areas .button {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    padding: 5px 20px;
    color: white;
    border-radius: 30px;
    font-weight: bold;
    border: none;
    transition: all .5s;
}

.areas .col:hover .fundo {
    opacity: .7;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.areas .col:hover img {
    opacity: 1;
}

.areas .col:hover h4 {
    color: #fff;
}

.areas .col:hover .button {
    background-color: #fff !important;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.lead fieldset div {
    padding: 10px 0;
    border-bottom: 1px solid #ccc;
}

.lead h3 {
    font-size: 1.1em;
    font-weight: bold;
    margin: 0;
}

.modalRecord .price {
    display: none;
}

@media(min-width: 601px) {
    .modalRecord .price {
        margin-top: -40px !important;
    }
}

.modalRecord input {
    height: 40px !important;
    border: 1px solid #ccc !important;
    padding: 0 1em !important;
    width: calc(100% - 2em) !important;
    margin: 5px 0 !important;
    font-size: 1em;
    box-shadow: none !important;
    border-radius: 5px !important;
    background-color: #fff !important;
}

.q label {
    margin-top: 20px;
}

.q select {
    display: block !important;
    width: 300px !important;
    margin-left: 0px !important;
    height: 3em !important;
}

.q .disabled {
    display: none !important;
}


/*-------- Historico de Registros --------*/

.history li {
    width: 100%;
    float: left;
    display: flex;
    align-items: center;
    flex-wrap: nowrap;
    justify-content: flex-start;
    margin: 0;
    padding: 20px;
    position: relative;
}

.history li::before {
    content: '';
    width: 4px;
    height: 120%;
    z-index: 0;
    top: 50%;
    left: calc(20px + 30px + 2px);
    background-color: #ccc;
    position: absolute;
}

.history ul li:last-child::before {
    opacity: 0;
}

.history hgroup {
    width: 100%;
    border-bottom: 1px solid #ccc;
    padding-bottom: 10px;
}

.history datalist {
    display: flex !important;
    align-items: center;
    flex-wrap: nowrap;
    justify-content: space-between;
}

.history ul svg {
    width: 70px !important;
    height: 70px;
    padding: 20px;
    border-radius: 50%;
    margin-right: 20px;
    position: relative;
}

.history .fa-user-edit {
    background-color: #305179;
    color: #fff;
}

.history .fa-dolly {
    background-color: #40cd28;
    color: #fff;
}

.history .fa-bullseye {
    background-color: #40cd28;
    color: #fff;
}

.history .fa-funnel-dollar {
    background-color: #dd3341;
    color: #fff;
}

.history time {
    font-size: .9em;
    font-style: italic;
    color: #999;
}

.history p {
    font-weight: normal !important;
    border-bottom: 0 !important;
    margin: 5px 0 !important;
    line-height: 1.25em;
}

.history cite {
    font-size: .9em;
    font-style: italic;
}

.history h3 {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.history .btn {
    width: auto !important;
    padding: 0 1em !important;
    background-color: #d50000 !important;
    font-size: .7em !important;
    height: 2.5em;
    line-height: 2.5em;
    text-transform: none;
}

.modalRecord {
    position: fixed;
    top: 0;
    left: 0;
    z-index: 9999;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
    -webkit-backdrop-filter: blur(2px);
    backdrop-filter: blur(2px);
    background-color: rgba(0, 0, 0, .5);
    height: 0;
    overflow: hidden;
    opacity: 0;
    transition: all 1s;
}

.modalRecord.active {
    opacity: 1;
    height: 100%;
    overflow: auto;
    padding: 20px;
}

.modalRecord .close:not(.white-text) {
    position: absolute;
    top: 20px !important;
    right: 20px;
    color: #888;
    font-size: 1.25em;
    border: none;
    padding: 0;
    color: #666 !important;
}

.modalRecord button.close {
    background-color: white;
}

.modalRecord .close.btn {
    position: relative;
    top: 0 !important;
    right: 0;
    font-size: 1em;
    color: #fff !important;
    margin-right: 0;
}

.modalRecord fieldset {
    position: relative;
    width: 100%;
    max-width: 700px;
    max-height: 110vh;
    overflow: auto;
    padding: 40px 40px !important;
    background-color: white;
    border-radius: 10px;
}

.modalRecord h4 {
    font-size: 1.5em;
    color: #c4302b;
    font-weight: bold;
    margin-top: 0;
    margin-bottom: 20px;
    text-align: center;
}

.modalRecord h3 {
    font-size: 1.25em;
    color: #c4302b;
    font-weight: bold;
}

.modalRecord label[for="note"] {
    font-size: 1em;
    margin-bottom: 10px;
    font-weight: bold;
}

.modalRecord textarea {
    border: 1px solid #ccc;
    border-radius: 5px;
    height: 8em;
    resize: none;
    padding: 10px;
    margin-top: 10px;
}

.modalRecord [type="checkbox"]:not(:checked),
.modalRecord [type="checkbox"]:checked {
    position: relative !important;
    left: 0 !important;
    visibility: initial !important;
}

.modalRecord [type="checkbox"]:not(:checked) {
    width: 20px !important;
    height: 20px !important;
    border: 1px solid #ccc !important;
    margin: 0 !important;
    margin-right: 10px !important;
}

.modalRecord [type="checkbox"]:checked {
    width: 20px !important;
    height: 20px !important;
    margin: 0 !important;
    margin-right: 10px !important;
    color: #c4302b !important;
}

.modalRecord label[for="transfer"] {
    display: flex;
    align-items: center;
    flex-wrap: nowrap;
    justify-content: flex-start;
    font-size: 1em;
    font-weight: bold;
}

.modalRecord select {
    display: none;
    width: 100px;
    border: 1px solid #ccc !important;
    margin-left: 10px;
    height: 2.5em;
    font-size: .9em;
    font-weight: normal;
}

.modalRecord .btn {
    background-color: #40cd28 !important;
    box-shadow: none !important;
    border-radius: 30px;
    margin-top: 30px;
}

.search-data .empty {
    margin-top: 60px;
}

.search-data .empty p {
    margin: 0;
}

.search-data table {
    width: 100%;
    float: left;
    margin: 20px 0 !important;
    border: 1px solid #ccc !important;
    border-radius: 5px !important;
}

.search-data table thead th,
.search-data table thead td {
    border: 1px solid #ccc !important;
    border-bottom: none !important;
    border-left: none !important;
    border-right: none !important;
}

@media(min-width: 993px) {
    .search-data table thead th,
    .search-data table thead td {
        border: 1px solid #ccc !important;
        border-top: none !important;
        border-left: none !important;
    }
    .search-data table thead th:last-of-type,
    .search-data table thead td:last-of-type {
        border-right: none !important;
    }
    .search-data td {
        border-right: 1px solid #ccc;
    }
    .search-data table tbody td:last-of-type {
        border-right: none !important;
    }
}

@media only screen and (max-width: 992px) {
    .search-data table thead th:first-of-type,
    .search-data table thead td:first-of-type {
        border-top: none !important;
    }
    .search-data .dataTables_length label {
        width: 100% !important;
        justify-content: center;
        text-align: center;
    }
    .search-data table.responsive-table thead {
        margin-bottom: -10px !important;
    }
    .search-data table.responsive-table thead tr {
        padding: 0 !important;
    }
    .search-data th {
        width: 70px !important;
        text-overflow: ellipsis;
        overflow: hidden;
        white-space: nowrap;
        text-align: left !important;
        font-size: .8em !important;
    }
    .search-data td {
        text-align: center !important;
    }
}

.search-data img {
    width: 50px;
    height: 50px;
    object-fit: cover;
    border-radius: 50%;
}

.search-data h2 {
    font-size: 2em;
    color: #666;
    font-weight: bold;
}

.search-data td {
    border-bottom: 1px solid #ccc;
}

.search-data svg {
    color: #dd3341;
}

.search-data small {
    color: #666;
    font-size: .9em;
    float: right;
}

.search-data input {
    height: 40px !important;
    border: 1px solid #ccc !important;
    padding: 0 1em !important;
    width: calc(100% - 2em) !important;
    margin: 5px 0 !important;
    font-size: 1em;
    box-shadow: none !important;
    border-radius: 5px !important;
    background-color: #fff !important;
}

.search-data select {
    margin: 0 !important;
    margin-top: 5px !important;
    margin-bottom: 15px !important;
    background-color: white !important;
    color: #999999 !important;
    padding-left: 1em !important;
    width: calc(100%) !important;
    border: 1px solid #ccc !important;
    border-radius: 5px !important;
    font-size: .9em !important;
}

.search-data .btn {
    border-radius: 5px !important;
    width: 100%;
    height: 40px;
    margin-top: 1.6em;
    background-color: #026FA7 !important;
    box-shadow: none !important;
    padding: 0 1em !important;
}

.search-data .stock {
    background-color: #40cd28 !important;
    padding: 0 .5em !important;
    text-transform: none;
    font-size: .9em;
}

.search-data .stock svg {
    color: #fff;
}

.search-data .select-wrapper input.select-dropdown {
    font-size: .9em !important;
}

.search-data .dropdown-content li>a,
.search-data .dropdown-content li>span {
    font-size: .9em !important;
    color: #666 !important;
}

.search-data .select-wrapper span.caret {
    right: 10px;
}

.search-data .filter {
    width: 100%;
    float: left;
    margin-bottom: 10px;
}

.search-data .flex {
    display: flex;
    align-items: center;
    justify-content: space-between;
    flex-wrap: nowrap;
    padding: 0 .75rem;
}

.search-data .flex .btn {
    width: fit-content;
    color: #305179 !important;
    background-color: #fff !important;
    border: 1px solid #305179 !important;
    margin-top: 0;
    height: 30px;
    line-height: 30px;
    text-transform: none;
    font-size: .9em;
}

.search-data .create {
    width: fit-content !important;
    background-color: #40cd28 !important;
    box-shadow: none !important;
    float: right;
    text-transform: none;
}

.paginator {
    width: 100% !important;
    float: left;
    display: flex;
    justify-content: center;
    text-align: center;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    color: #000 !important;
    background-color: transparent !important;
    height: initial !important;
    line-height: initial !important;
    box-shadow: none !important;
}

.paginator_item {
    width: 35px;
    height: 35px;
    border: 1px solid #c4302b;
    color: #c4302b;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 5px;
}

.paginator_item.paginator_active {
    width: 35px !important;
    height: 35px !important;
    border: 1px solid #c4302b;
    color: #fff !important;
    background-color: #c4302b;
    border-radius: 50% !important;
}

.paginator_item:first-of-type,
.paginator_item:last-of-type {
    width: initial;
    height: initial;
    color: #c4302b;
    border: none;
    border-radius: 0;
    border-bottom: 1px solid #c4302b;
}

.saved select {
    margin: 0 10px !important;
}

.saved input {
    margin-left: 10px !important;
}

.saved .dataTables_wrapper .paginate_button.current,
.saved .dataTables_wrapper .paginate_button:hover {
    background-color: #c4302b !important;
}

.saved .dataTables_wrapper .dataTables_paginate .paginate_button.current,
.saved .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    color: #fff !important;
}

.saved .disabled {
    display: none !important;
}

.saved .btn {
    border-radius: 30px;
    height: 3em;
    line-height: 3em;
    background-color: #40cd28 !important;
    box-shadow: none !important;
    width: auto !important;
    text-transform: none;
}

.saved table [type="checkbox"]:not(:checked),
.saved table [type="checkbox"]:checked {
    position: relative !important;
    left: 0 !important;
    visibility: initial !important;
}

.saved table [type="checkbox"]:not(:checked) {
    width: 20px !important;
    height: 20px !important;
    border: 1px solid #ccc !important;
    margin: 0 auto !important;
}

.saved thead tr th {
    text-align: center !important;
}

.saved table [type="checkbox"]:checked {
    width: 20px !important;
    height: 20px !important;
    margin: 0 auto !important;
    color: #c4302b !important;
}

.saved tbody tr td:nth-of-type(6) {
    width: 50px !important;
}

.saved .flex-end {
    display: flex;
    align-items: center;
    flex-wrap: wrap;
    justify-content: space-between;
    margin-top: -1em;
}

.saved .flex-end .btn {
    height: 2em;
    line-height: 2em;
    margin-bottom: 20px;
    padding: 0 1em !important;
}

.saved .flex-end button {
    background-color: #c4302b !important;
    display: none;
}

.progres {
    position: fixed;
    top: 0;
    left: 0;
    z-index: 9999;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
    -webkit-backdrop-filter: blur(2px);
    backdrop-filter: blur(2px);
    background-color: rgba(0, 0, 0, .5);
    height: 0;
    overflow: hidden;
    opacity: 0;
    transition: all 1s;
}

.progres.active {
    opacity: 1;
    height: 100%;
    overflow: auto;
    padding: 20px;
}

.progres .close {
    position: absolute;
    top: 20px;
    right: 20px;
    color: #888;
    font-size: 1.25em;
}

.progres article {
    position: relative;
    width: 100%;
    max-width: 450px;
    max-height: 80vh;
    overflow: auto;
    padding: 60px 40px !important;
    background-color: white;
    text-align: center;
    border-radius: 10px;
}

.progres p {
    color: #999;
    margin: 0;
}

.progres .complete {
    width: 100%;
    height: 8px;
    background-color: #ccc;
    border-radius: 10px;
    margin: 10px 0;
    position: relative;
    overflow: hidden;
}

.progres .complete div {
    transition: all .5s;
    width: 0;
    height: 100%;
    position: absolute;
    top: 0;
    left: 0;
    background-color: #c4302b;
}

.progres small {
    font-weight: bold;
}

.modalCreate {
    position: fixed;
    top: 0;
    left: 0;
    z-index: 9999;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0;
    -webkit-backdrop-filter: blur(2px);
    backdrop-filter: blur(2px);
    background-color: rgba(0, 0, 0, .5);
    height: 0;
    overflow: hidden;
    opacity: 0;
    transition: all 1s;
}

.modalCreate.active {
    opacity: 1;
    height: 100%;
    overflow: auto;
    padding: 20px;
}

.modalCreate .close {
    position: absolute;
    top: 20px;
    right: 20px;
    color: #888;
    font-size: 1.25em;
}

.modalCreate fieldset {
    position: relative;
    max-width: 450px;
    max-height: 80vh;
    overflow: auto;
    padding: 60px 40px !important;
    background-color: white;
    text-align: center;
    border-radius: 10px;
}

.modalCreate h2 {
    font-size: 1.5em;
    text-align: center;
    color: #026FA7 !important;
    font-weight: bold;
    margin: 0;
}

.modalCreate input {
    border: none !important;
    text-align: center;
    box-shadow: none !important;
    margin: 20px 0 !important;
    font-size: 1.5em;
}

.modalCreate input::placeholder {
    color: #999;
}

.modalCreate .btn {
    border-radius: 30px;
    height: 3em;
    line-height: 3em;
    background-color: #40cd28 !important;
    box-shadow: none !important;
}

.empty {
    width: 100%;
    float: left;
    text-align: center !important;
    padding: 20px;
}

.empty svg {
    font-size: 4em;
    color: #026FA7;
}

.empty h5 {
    font-size: 1em;
    font-weight: bold;
    color: #026FA7;
    margin-bottom: 0;
}

.empty p {
    text-align: center;
}


/*-------- Cadastro --------*/

.cadastro {
    padding: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.cadastro h2 {
    font-size: 2em;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    font-weight: bold;
}

.cadastro fieldset {
    width: 100%;
    max-width: 600px;
}

.cadastro label {
    font-size: 1em;
}

.cadastro p {
    text-align: left !important;
    margin: 10px 0 !important;
}

.cadastro input {
    margin: 0 !important;
    margin-top: 5px !important;
    margin-bottom: 15px !important;
    background-color: white !important;
    color: #999999 !important;
    padding-left: 1em !important;
    width: calc(100% - 1em) !important;
    border: 1px solid #999 !important;
    border-radius: 5px !important;
    font-size: .9em !important;
}

.cadastro textarea {
    margin: 0 !important;
    margin-top: 5px !important;
    margin-bottom: 15px !important;
    background-color: white !important;
    color: #999999 !important;
    padding: 1em !important;
    width: 100% !important;
    border: 1px solid #999 !important;
    border-radius: 5px !important;
    font-size: .9em !important;
    resize: none;
    height: 8em !important;
    outline: none !important;
}

.cadastro select {
    margin: 0 !important;
    margin-top: 5px !important;
    margin-bottom: 15px !important;
    background-color: white !important;
    color: #999999 !important;
    padding-left: 1em !important;
    width: calc(100%) !important;
    border: 1px solid <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    border-radius: 5px !important;
    font-size: .9em !important;
}

.cadastro input::placeholder {
    color: #666;
    font-size: 1em !important;
}

@media(min-width: 601px) {
    .cadastro .flex {
        display: flex;
        align-items: center;
        justify-content: space-between;
        flex-wrap: wrap;
        margin-top: 10px;
    }
}

.cadastro [type="checkbox"]+label {
    font-size: 1em !important;
    padding-left: 25px;
    margin-right: 10px;
}

.cadastro [type="checkbox"].filled-in:not(:checked)+label:after {
    border: 1px solid <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.cadastro [type="checkbox"].filled-in:checked+label:after {
    border: 1px solid <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.cadastro p {
    margin: 0 !important;
}

.cadastro p:last-child [type="checkbox"]+label {
    margin: 0 !important;
}

.cadastro .btn {
    margin-top: 20px;
    padding: 0 4em;
    height: 3em;
    line-height: 3em;
    box-shadow: none !important;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
    border-radius: 30px;
}

.cadastro .center {
    margin-top: 10px;
}

.cadastro .center label {
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    font-weight: bold;
    margin-bottom: 10px;
}

.cadastro .flex {
    width: 100%;
    float: left;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 20px;
}

.cadastro .full {
    max-width: 100% !important;
}

.cadastro .full .dropify-wrapper {
    width: 100% !important;
    height: 300px !important;
    padding: 0 !important;
    margin-right: 20px;
}

.cadastro .full .dropify-wrapper img {
    width: 100% !important;
    height: 300px !important;
    object-fit: contain !important;
    object-position: center;
}

.cadastro .ck a {
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
}

.cadastro .ck ul {
    padding-left: 2em !important;
}

.cadastro .ck ul li {
    list-style: disc !important;
}

.cadastro .ck-content {
    padding: 10px !important;
}

.dropify-wrapper p {
    text-align: center !important;
}

.cadastro .flex .dropify-wrapper button {
    display: none !important;
}

.cadastro .flex .dropify-wrapper p {
    font-size: .7em !important;
    line-height: .9em !important;
    padding: 0 20px !important;
}

.cadastro .flex .dropify-wrapper,
.cadastro .flex .dropify-wrapper img {
    width: 120px !important;
    height: 120px !important;
    border-radius: 50% !important;
}

.cadastro .dropify-wrapper {
    width: 100% !important;
    height: 200px !important;
    padding: 0 !important;
    margin-right: 20px;
}

.cadastro .dropify-wrapper img {
    width: 100% !important;
    height: 200px !important;
    object-fit: cover !important;
    object-position: center;
}

.cadastro .dropify-wrapper .dropify-preview .dropify-infos .dropify-infos-inner p,
.cadastro .dropify-wrapper .dropify-preview .dropify-infos .dropify-infos-inner p {
    width: 100% !important;
    white-space: normal !important;
    line-height: 1.25em !important;
}

.cadastro form p {
    text-align: center;
}


/*-------- Controller Social --------*/

.midia {
    padding: 40px 5%;
}

.midia h2 {
    font-size: 1.75em;
    margin-top: 0;
    font-weight: bold;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.midia form {
    border: 1px solid #ccc;
    padding: 20px;
    width: 100%;
    float: left;
}

.midia .flex {
    display: flex;
    align-items: center;
    flex-wrap: nowrap;
}

.midia div.flex {
    margin-top: 20px;
}

.midia .flex .flex {
    margin-top: 0;
}

.midia .flex p {
    margin: 0 !important;
}

.midia .switch {
    text-align: left;
    margin: 0px 0 !important;
    margin-left: 10px !important;
    align-items:center;
    width: 9rem;
    display: flex;
    justify-content: space-between;
}

.midia .switch label input[type=checkbox]:checked+.lever {
    background-color: #ccc;
}

.midia .switch label input[type=checkbox]:checked+.lever:after {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.midia p {
    margin: 0;
    margin-bottom: 10px;
    font-size: .9em;
    color: #666;
}

.midia svg {
    width: 55px !important;
    height: 50px;
    background-color: #000;
    color: #fff;
    padding: 10px;
    margin-right: 10px;
}

.midia label {
    width: 100%;
    float: left;
}

.midia span {
    height: 32px;
    line-height: 30px;
    background-color: #ccc;
    border: 1px solid #999 !important;
    color: #333;
    padding: 0 10px;
}

.midia input {
    margin: 0 !important;
    background-color: white !important;
    color: #999999 !important;
    padding-left: 1em !important;
    width: calc(100% - 1em) !important;
    border: 1px solid #999 !important;
    border-left: none !important;
    font-size: .9em !important;
    height: 30px;
    box-shadow: none !important;
}

.midia .fa-facebook-f {
    background-color: #3b5998;
}

.midia .fa-instagram {
    background: #d6249f;
    background: radial-gradient(circle at 30% 107%, #fdf497 0%, #fdf497 5%, #fd5949 45%, #d6249f 60%, #285AEB 90%);
}

.midia .fa-linkedin-in {
    background-color: #0e76a8;
}

.midia .fa-youtube {
    background-color: #c4302b;
}

.midia .btn {
    margin-top: 20px;
    padding: 0 4em;
    height: 3em;
    line-height: 3em;
    box-shadow: none !important;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
    border-radius: 30px;
}


/*-------- Headline --------*/

.headline {
    position: relative;
    padding: 60px 5%;
    min-height: 100vh;
    display: flex;
    align-content: center;
    flex-wrap: wrap;
    justify-content: center;
}

.headline::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    opacity: .9;
}

.headline .action {
    padding: 0 !important;
    padding: 10px 20px !important;
    position: absolute;
    top: 20px;
    right: 20px;
    background-color: rgba(255, 255, 255, .3);
    color: white;
    z-index: 9999;
}

.headline .action::before {
    content: none;
}

.headline a {
    color: white !important;
}

.headline h1 {
    width: 100%;
    float: left;
    position: relative;
    text-align: center;
    font-size: 2.5em;
    font-weight: bold;
    color: white;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    margin-top: 1em;
}

.headline p {
    width: 100%;
    float: left;
    position: relative;
    text-align: center;
    font-size: 1.25em;
    color: white;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
}

.headline figure img:first-child {
    width: 100%;
    height: 100%;
    object-fit: cover;
    position: absolute;
    top: 0;
    left: 0;
    z-index: -1;
}

.headline figure img:nth-of-type(2) {
    width: 100%;
    float: left;
    height: 70px;
    object-fit: contain;
    position: relative;
    filter: contrast(0%) brightness(1000%);
}

.headline fieldset {
    width: 100%;
    float: left;
    position: relative;
    display: flex !important;
    justify-content: center;
}

.headline form {
    width: 100%;
    max-width: 500px;
    margin-top: 2em;
}

.headline label {
    width: 100% !important;
    float: left;
}

.headline .btn {
    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;
    height: 3em;
    line-height: 3em;
    text-transform: none;
    font-weight: bold;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    box-shadow: none !important;
    border-radius: 30px !important;
}

.headline label {
    max-width: 500px;
    width: 100%;
    float: left;
    color: white !important;
    font-family: 'Open Sans', Tahoma, Geneva, Verdana, sans-serif;
    font-size: 1em;
    display: flex;
    align-items: center;
    flex-wrap: nowrap;
    padding: 10px 40px 10px 40px !important;
    position: relative;
    border: 1px solid #fff;
    margin-bottom: 10px;
    cursor: all-scroll !important;
}

.headline p label {
    display: block;
    padding: 0 !important;
    padding-left: 30px !important;
    position: relative;
    border: none;
    margin-bottom: 0;
}

.headline .resize {
    position: absolute;
    top: 0;
    left: 0;
    background-color: white !important;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    border: none;
    width: 30px;
    height: calc(100%);
    font-size: 1em;
    padding: 0 !important;
    cursor: all-scroll !important;
}

.headline .delete {
    position: absolute;
    top: 0;
    right: 0;
    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;
    color: #fff !important;
    border: none;
    width: 30px;
    height: calc(100%);
    font-size: 1em;
    padding: 0 !important;
    display: flex;
    align-items: center;
    justify-content: center;
}

.headline hgroup {
    width: 100% !important;
}

.headline input {
    border: 1px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;
    border-radius: 5px !important;
    margin-top: 10px !important;
    padding-left: 1em !important;
    width: calc(100% - 1.1em) !important;
    box-shadow: none !important;
    outline: none !important;
    margin-bottom: 0 !important;
}

.headline select {
    border: 1px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;
    border-radius: 5px !important;
    margin-top: 10px !important;
    background-color: transparent !important;
    margin-bottom: 10px !important;
    box-shadow: none !important;
    outline: none !important;
    padding-left: 1em !important;
}

.headline select option {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
}

.headline textarea {
    border: 1px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;
    border-radius: 5px !important;
    margin-top: 10px !important;
    background-color: transparent !important;
    margin-bottom: 10px !important;
    box-shadow: none !important;
    outline: none !important;
    padding: 1em !important;
    min-height: 8em !important;
    resize: none;
}

.headline input::placeholder,
.headline textarea::placeholder {
    color: #999 !important;
}

input[type=number]::-webkit-inner-spin-button {
    -webkit-appearance: none;
}

input[type=number] {
    -moz-appearance: textfield;
    appearance: textfield;
}

.headline .flex {
    display: flex;
    align-items: center;
    justify-content: center;
    flex-wrap: wrap;
    margin: 20px 0;
}

.headline .flex p {
    width: fit-content !important;
    margin: 5px 10px;
}

.headline .flex label {
    color: #ccc !important;
}

.headline [type="radio"]:not(:checked)+label:before,
.headline [type="radio"]:not(:checked)+label:after {
    border: 1px solid #fff !important;
}

.headline [type="checkbox"]:not(:checked)+label:before,
.headline [type="checkbox"]:not(:checked)+label:after {
    border: 1px solid #fff !important;
}

.headline [type="radio"]:checked+label:after,
.headline [type="radio"].with-gap:checked+label:after {
    background-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;
    border-color: <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;
}

.headline [type="checkbox"]:checked+label:before {
    border-right: 2px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;
    border-bottom: 2px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;
}

.headline .number {
    display: flex;
    align-items: center;
    flex-wrap: nowrap;
}

.headline .number hgroup {
    width: min-content !important;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    border: 1px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;
    height: auto !important;
    padding: 0 !important;
    margin: 0 !important;
    height: 3.12em !important;
    margin-top: 10px !important;
}

.headline .number input {
    width: 100% !important;
    border-right: none !important;
    border-radius: 5px 0 0 5px !important;
}

.headline .number button {
    margin: 0 !important;
    padding: 0 !important;
    background-color: transparent !important;
    border: none !important;
    font-size: .9em;
    width: 30px;
}

.headline .number button:first-child {
    border-bottom: 1px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?> !important;
}

.headline .foot {
    width: 100%;
    float: left;
}

.headline fieldset {
    position: relative;
    z-index: 1;
}

.headline svg:not(.svg-inline--fa) {
    position: absolute;
    bottom: 0px;
    left: 0;
    width: 100%;
    color: #fff !important;
}

.headline svg:not(.svg-inline--fa) path {
    fill: #fff;
}

@media (min-width: 601px) {
    .headline svg:not(.svg-inline--fa) {
        bottom: -60px;
    }
}


/*-------- Modal --------*/

.window {
    background-color: rgba(0, 0, 0, .7);
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
    transform: translateY(-100%);
    transition: all .5s;
    padding: 40px;
}

.window.active {
    transform: translate(0);
}

.window.file fieldset {
    max-width: 700px;
}

.window.file .dropify-wrapper {
    width: 100% !important;
    margin-bottom: 20px !important;
}

.window.file .dropify-wrapper img {
    width: 100% !important;
}

.window fieldset {
    background-color: white !important;
    padding: 30px !important;
    border-radius: 20px !important;
    position: relative;
    overflow: auto;
    position: relative;
    max-width: 500px;
    max-height: 90vh;
    width: 100%;
}

.window .close:not(.btn) {
    position: absolute;
    top: 25px;
    right: 30px;
    color: #666;
    font-size: 1.5em;
}

.window.filters label[for="name"] {
    display: flex;
    align-items: center;
    flex-wrap: nowrap;
    width: 100%;
    float: left;
}

.window.filters hgroup {
    width: 100%;
    float: left;
}

.window.filters .new {
    border: none;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    color: white;
    height: 3.1em;
    margin-top: 12px;
    width: 45px;
}

.window.filters .flex {
    flex-wrap: wrap;
}

.window [type="checkbox"]:not(:checked)+label:before,
.window [type="checkbox"]:not(:checked)+label:after {
    border: 1px solid #999 !important;
}

.window [type="checkbox"]:checked+label:before {
    border-right: 2px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;
    border-bottom: 2px solid <?= (is_null($color) || empty($color->getColorSecond())) ? '#e0183c' : $color->getColorSecond() ?>;
}

.window.filters .flex {
    border: 1px solid #ccc;
    padding: 20px;
}

.window.filters .flex p {
    margin-top: 2.5px !important;
    width: 100%;
    float: left;
    display: flex;
    align-items: center;
    flex-wrap: nowrap;
    justify-content: space-between;
}

.window.filters .fa-trash-alt {
    color: #ee4a18;
}

.window h2 {
    font-size: 1.5em;
    font-weight: bold;
    color: rgb(54, 24, 207);
    margin-top: 0;
}

.window h3 {
    font-size: 1.1em;
    font-weight: bold;
}

.window label {
    font-size: 1em;
}

.window #text,
.window #quantidade,
.window #options {
    width: 100%;
    float: left;
    border: 1px solid #ccc;
    padding: 20px;
    margin: 20px 0;
}

.window .flex {
    padding: 0 .75rem;
    width: 100%;
    float: left;
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 20px;
}

.window .flex p {
    margin: 0 !important;
}

.window .switch {
    text-align: left;
    margin: 0px 0 !important;
    margin-left: 10px !important;
    display: flex;
    justify-content: space-between;
}

.window .switch label input[type=checkbox]:checked+.lever {
    background-color: #ccc;
}

.window .switch label input[type=checkbox]:checked+.lever:after {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}

.window input {
    margin: 0 !important;
    margin-top: 5px !important;
    margin-bottom: 15px !important;
    background-color: white !important;
    color: #999999 !important;
    padding-left: 1em !important;
    width: calc(100% - 1em) !important;
    border: 1px solid #999 !important;
    border-radius: 5px !important;
    font-size: .9em !important;
}

.window textarea {
    margin: 0 !important;
    margin-top: 5px !important;
    margin-bottom: 15px !important;
    background-color: white !important;
    color: #999999 !important;
    padding: 1em !important;
    width: 100% !important;
    border: 1px solid #999 !important;
    border-radius: 5px !important;
    font-size: .9em !important;
    resize: none;
    height: 8em !important;
    outline: none !important;
}

.window select {
    margin: 0 !important;
    margin-top: 5px !important;
    margin-bottom: 15px !important;
    background-color: white !important;
    color: #999999 !important;
    padding-left: 1em !important;
    width: calc(100%) !important;
    border: 1px solid #999 !important;
    border-radius: 5px !important;
    font-size: .9em !important;
}

.window input::placeholder {
    color: #666;
    font-size: 1em !important;
}

.window .btn {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    padding: 0 3em;
    font-size: .8em;
    box-shadow: none;
    font-weight: bold;
    height: 3em;
    line-height: 3em;
    transition: all 1s;
    border-radius: 5px;
    margin-bottom: 20px !important;
}

.window label[for="options"] .flex {
    padding: 0 !important;
}

.window .flex input {
    margin: 0 !important;
    border-right: none !important;
    border-radius: 5px 0 0 5px !important;
}

.window .more {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    color: white !important;
    width: 50px;
    line-height: 30px;
    height: 3em;
    text-align: center;
    display: flex;
    align-items: center;
    justify-content: center;
}

.window .minus {
    background-color: #c4302b;
    color: white !important;
    width: 50px;
    line-height: 30px;
    height: 3em;
    text-align: center;
    display: flex;
    align-items: center;
    justify-content: center;
}


/*-------- Files --------*/

.files {
    padding: 40px 20px;
}

.files .col div {
    cursor: all-scroll;
    background-color: white !important;
}

.files .col div button {
    width: 100%;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    color: white !important;
    border: none !important;
    padding: 10px;
    cursor: all-scroll !important;
}

.files .col div button svg {
    width: 100%;
    height: 20px;
    font-size: .9em;
    color: white !important;
    margin: 0;
}

.files .col div button svg path {
    fill: white !important;
}

.files fieldset {
    width: 100% !important;
}

.files header {
    width: 100% !important;
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 2em;
}

.files iframe {
    width: 100%;
    height: auto;
    object-fit: cover;
    margin: 0 !important;
    margin-top: -10px !important;
    margin-bottom: -15px !important;
}

.files time {
    position: absolute;
    right: 10px;
    top: 90px;
    background-color: #333;
    color: white;
    font-size: .9em;
    padding: 5px 10px;
}

.files h2 {
    font-size: 2em;
    font-weight: bold;
    color: #305179;
    margin: 0;
}

.files .btn-large {
    background-color: #32CD32 !important;
    text-transform: none;
    box-shadow: none !important;
    border-radius: 10px;
    height: 2.5em;
    line-height: 2.5em;
    padding: 0 1em;
}

.files .col {
    margin-top: 2em;
}

.files .l3 div {
    border: 1px solid #ccc;
    border-radius: 10px;
    position: relative;
    overflow: hidden;
}

.files .l3 svg {
    width: 100% !important;
    text-align: center;
    height: 50px;
    margin: 40px 0;
}

.files .l3 hgroup svg {
    width: 100% !important;
    text-align: center;
    height: 20px;
    margin: 0;
}

.files .l3 img {
    width: 100%;
    height: 135px;
    object-fit: cover;
    margin-bottom: -7px;
}

.files .fa-file-pdf {
    color: #c4302b;
}

.files .fa-file-excel {
    color: #0f8f0f;
}

.files .fa-file-csv {
    color: #23db23;
}

.files .fa-file-word {
    color: rgb(26, 114, 196);
}

.files .fa-file-powerpoint {
    color: #ee4a18;
}

.files .l3 hgroup:nth-of-type(1) {
    border-top: 1px solid #ccc;
    border-bottom: 1px solid #ccc;
    padding: 10px 20px;
}

.files .l3 hgroup:nth-of-type(1) p {
    margin: 0;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
    font-size: .9em;
}

.files .l3 hgroup:nth-of-type(2) {
    display: flex;
    align-items: center;
    flex-wrap: nowrap;
    justify-content: center;
}

.files .l3 a {
    width: 100%;
    padding: 10px;
}

.files .l3 a:nth-of-type(1) {
    background-color: #305179;
    color: white;
}

.files .l3 a:nth-of-type(2) {
    background-color: #c4302b;
    color: white;
}

.files input {
    border: 1px solid #999 !important;
    border-radius: 5px !important;
    width: calc(100% - 1em) !important;
    padding-left: 1em !important;
    box-shadow: none !important;
    height: 2.9em !important;
    margin: 0 !important;
}

.files select {
    border: 1px solid #999 !important;
    border-radius: 5px !important;
    box-shadow: none !important;
}

.files .btn {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    box-shadow: none !important;
    height: 2.9em !important;
    line-height: 2.9em !important;
    text-transform: none;
    margin-bottom: -5px !important;
    border-radius: 5px;
}

.files .col {
    margin: 0 !important;
    margin-bottom: 2em !important;
}

.files form {
    display: flex;
    align-items: flex-end;
    justify-content: start;
    flex-wrap: wrap;
}


/*-------- Controller Config --------*/

.setting label {
    display: flex;
    align-items: center;
    color: #333;
    font-weight: bold;
    margin: 5px 0;
    line-height: 1em;
}

.setting label input {
    margin: 0 !important;
    margin-left: 10px !important;
}

.setting input::placeholder {
    color: #999;
    font-weight: normal;
}

.setting label span {
    width: 150px;
}

.setting img {
    width: 30px;
    height: 30px;
    object-fit: contain;
    float: left;
    margin-right: 10px;
}

.setting .switch {
    text-align: left;
    margin: 10px 0 !important;
    margin-right: 0 !important;
    display: flex;
    justify-content: space-between;
}

.setting .switch .lever {
    margin-right: 0 !important;
}

.setting .switch label input[type=checkbox]:checked+.lever {
    background-color: #ccc;
}

.setting .switch label input[type=checkbox]:checked+.lever:after {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
}


/*-------- Search --------*/

.search {
    padding: 20px;
}

.search .jsgrid-filter-row {
    display: none !important;
}

.search h2 {
    font-size: 2em;
    font-weight: bold;
    color: #999999;
    margin-top: 0;
}

.search tr th {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    color: #fff;
    transition: all .5s;
}

.search tr th:hover,
.search .jsgrid-header-sort {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    opacity: .7;
}

.search .jsgrid-header-sort-desc:before {
    border-color: #fff transparent transparent !important;
}

.search .jsgrid-header-sort-asc:before {
    border-color: transparent transparent #fff !important;
}

.search .jsgrid-search-mode-button,
.search .jsgrid-button.jsgrid-edit-button {
    display: none;
}

.search .jsgrid-pager-container {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    color: #fff;
    padding: 0 0px;
    text-align: center;
}

.search .jsgrid-pager-page a {
    color: white;
}

.search .jsgrid-pager-page.jsgrid-pager-current-page {
    color: #ccc;
}

.search .jsgrid-pager-nav-button a {
    color: #ccc;
}

.search tr:hover td {
    background: #b4e2fa;
    border-color: #b4e2fa;
}

.search img {
    width: 90px !important;
    height: 90px !important;
    border-radius: 10px;
    object-fit: cover;
}

.search.testimony img {
    width: 60px !important;
    height: 60px !important;
    border-radius: 50%;
    object-fit: cover;
}

.search h2.flex {
    display: flex;
    align-items: center;
    flex-wrap: wrap;
    justify-content: space-between;
}

.search .btn {
    font-size: .5em;
    text-transform: none;
    box-shadow: none !important;
    background-color: #23db23 !important;
    padding: 0 1em !important;
    border-radius: 10px;
}

.dataTables_wrapper .dataTables_length label,
.dataTables_wrapper .dataTables_filter label {
    display: flex;
    align-items: center;
    width: max-content !important;
}

.dataTables_wrapper select {
    margin: 0 5px !important;
    display: block !important;
    float: left !important;
    height: 40px !important;
    border: 1px solid #ccc !important;
    border-radius: 5px !important;
}

.dataTables_wrapper input {
    width: 150px !important;
    margin: 0 !important;
    margin-left: 5px !important;
    height: 40px !important;
    border: 1px solid #ccc !important;
}

.dataTables_wrapper .fa-trash-alt {
    color: #c4302b;
}

.dataTables_wrapper table.dataTable {
    width: 100%;
    float: left;
    margin: 20px 0 !important;
    border: 1px solid #ccc !important;
    border-radius: 5px !important;
}

.dataTables_wrapper table.dataTable thead th,
.dataTables_wrapper table.dataTable thead td {
    border: 1px solid #ccc !important;
    border-bottom: none !important;
    border-left: none !important;
    border-right: none !important;
}

.dataTables_wrapper .paginate_button {
    border: 1px solid #ccc !important;
    background-color: transparent !important;
    margin: 0 !important;
    border-left: none !important;
    transition: all .5s;
    padding: 10px;
    color: #666;
    cursor: pointer;
}

.dataTables_wrapper tbody tr td:last-child {
    width: 80px;
}

#variations .dataTables_paginate .paginate_button.current,
#variations .dataTables_paginate .paginate_button.current:hover,
#stock .dataTables_paginate .paginate_button.current,
#stock .dataTables_paginate .paginate_button.current:hover {
    color: #fff !important;
}

.dataTables_wrapper .paginate_button.current {
    background: none !important;
    background-color: #191D55 !important;
    color: #fff !important;
}

.dataTables_wrapper .paginate_button:hover {
    background: none !important;
    background-color: #191D55 !important;
    color: #fff !important;
}

.dataTables_wrapper .previous {
    border-left: 1px solid #ccc !important;
    border-radius: 5px 0 0 5px;
}

.dataTables_wrapper .next {
    border-radius: 0 5px 5px 0;
}

.dataTables_paginate.paging_simple_numbers {
    float: right;
}

#variations .disabled,
#stock .disabled {
    color: #ccc !important;
    display: none;
}

#variations img {
    width: 90px;
    height: 90px;
    border-radius: 50%;
    object-fit: cover;
}

.dataTables_wrapper td a {
    color: #333;
    text-decoration: underline;
}

.dataTables_wrapper td:last-of-type a {
    text-decoration: none;
}

@media(min-width: 993px) {
    .dataTables_wrapper table.dataTable thead th,
    .dataTables_wrapper table.dataTable thead td {
        border: 1px solid #ccc !important;
        border-top: none !important;
        border-left: none !important;
    }
    .dataTables_wrapper table.dataTable thead th:last-of-type,
    .dataTables_wrapper table.dataTable thead td:last-of-type {
        border-right: none !important;
    }
}

@media only screen and (max-width: 992px) {
    .dataTables_wrapper table.dataTable thead th:first-of-type,
    .dataTables_wrapper table.dataTable thead td:first-of-type {
        border-top: none !important;
    }
    .dataTables_wrapper input {
        width: 250px !important;
    }
    .dataTables_wrapper select {
        width: 50px !important;
    }
    .dataTables_wrapper .dataTables_length label {
        width: 100% !important;
        justify-content: center;
        text-align: center;
    }
    .dataTables_wrapper table.responsive-table thead {
        margin-bottom: -10px !important;
    }
    .dataTables_wrapper table.responsive-table thead tr {
        padding: 0 !important;
    }
    .dataTables_wrapper th {
        width: 70px !important;
        text-overflow: ellipsis;
        overflow: hidden;
        white-space: nowrap;
        text-align: left !important;
        font-size: .8em !important;
    }
    .dataTables_wrapper td {
        text-align: center !important;
    }
}


/*-------- Perfil --------*/

.dropify-wrapper {
    width: 200px !important;
    height: 200px !important;
    padding: 0 !important;
    margin-right: 20px;
}

.dropify-wrapper img {
    width: 200px !important;
    height: 200px !important;
    object-fit: cover !important;
    object-position: top;
}

.dropify-wrapper .dropify-preview .dropify-infos .dropify-infos-inner p {
    white-space: normal !important;
    line-height: 1.25em !important;
}

.perfil {
    padding: 0 !important;
    width: 100% !important;
}

.perfil header {
    background-color: #ff4081;
    padding: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-wrap: wrap;
}

.perfil h2 {
    font-size: 2em;
    font-weight: bold;
    color: #fccfd0;
    margin: 0;
    margin-top: 10px;
}

.perfil h3 {
    font-size: 1em;
    color: #fff;
    margin: 5px 0;
    border: 2px solid #fff;
    padding: 5px 10px;
    border-radius: 30px;
    width: max-content;
}

.perfil .col {
    padding: 20px !important;
}

.perfil h4 {
    font-size: 2em;
    font-weight: bold;
    color: #ccc;
    margin: 0;
}

.perfil ul li {
    padding: 5px 10px;
}

.perfil ul li:nth-of-type(odd) {
    background-color: #fac6c7;
}

.perfil ul li:nth-of-type(even) {
    background-color: rgb(247, 242, 242);
}

.perfil select {
    margin: 0 !important;
    margin-top: 5px !important;
    margin-bottom: 15px !important;
    background-color: white !important;
    color: #999999 !important;
    padding-left: 1em !important;
    width: calc(100%) !important;
    border: 1px solid <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    border-radius: 5px !important;
    font-size: .9em !important;
}

.perfil tr th {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    color: #fff;
    border-radius: 0;
    border: none;
    text-align: center;
}

.perfil tr td {
    color: #666;
    border-radius: 0;
    border: none;
    text-align: center;
    padding: 5px;
}

.perfil tr th:first-child,
.perfil tr td:first-child {
    text-align: left;
}

.perfil .btn.disabled,
.perfil .btn:disabled {
    opacity: .7 !important;
}

.perfil .btn {
    margin-top: 10px;
    padding: 0 2em;
    box-shadow: none !important;
    background-color: #ccc !important;
    font-weight: bold;
    border-radius: 30px;
    color: #fff !important;
    opacity: 1 !important;
}


/*-------- Painel de Instalação --------*/

.install {
    padding: 20px !important;
    display: flex !important;
    align-items: center;
    justify-content: center;
    min-height: 100vh;
    background-color: #ccc;
}

.install img {
    width: 100%;
    height: 50px;
    object-fit: contain;
}

.install h2 {
    font-size: 2em;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?>;
    font-weight: bold;
}

.install form {
    width: 100%;
    max-width: 600px;
    background-color: white;
    padding: 40px;
    box-shadow: 0 0 10px 0px rgba(0, 0, 0, .3);
}

.install label {
    font-size: 1em;
    color: #333;
    font-weight: bold;
    display: flex;
    align-items: center;
    margin: 5px 0;
    position: relative;
}

.install label span {
    width: 50%;
    padding-right: 10px;
}

.install input {
    margin: 0 !important;
    background-color: white !important;
    color: #999999 !important;
    padding-left: 1em !important;
    width: calc(100% - 1em) !important;
    border: 1px solid #999 !important;
    border-radius: 5px !important;
    font-size: .9em !important;
}

.install input::placeholder {
    color: #999;
    font-size: 1em !important;
    font-weight: normal;
}

.install button[type="button"] {
    border: none;
    position: absolute;
    right: 5px;
    background-color: transparent !important;
}

.install form {
    display: none;
}

.install form.active {
    display: block;
}

.install .card {
    margin-bottom: 40px !important;
    box-shadow: none;
}

.install .card .card-content {
    padding: 5px 10px;
    display: flex;
    align-items: center;
    border: 1px solid #03a9f4 !important;
    color: #03a9f4 !important;
}

.install .orange {
    background-color: #fff !important;
}

.install .card p {
    margin: 0;
    position: relative;
    top: -2px;
    line-height: 1.25em;
    font-size: .8em;
}

.install .close {
    position: absolute;
    top: 0px !important;
    color: #03a9f4 !important;
}

.install p {
    text-align: center;
    font-size: #666;
    margin-bottom: 40px;
}

.install .btn {
    margin-top: 20px;
    padding: 0 4em;
    height: 3em;
    line-height: 3em;
    box-shadow: none !important;
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
    border-radius: 30px;
}


/*-------- TIPOGRAFIA --------*/

button {
    cursor: pointer !important;
}

input {
    box-shadow: none !important;
}

.row {
    margin-bottom: 0 !important;
}

address {
    font-style: normal;
}

cite {
    font-style: normal;
}

strong {
    font-weight: bold !important;
}

figcaption {
    display: none !important;
}

figure {
    margin: 0 !important;
}

fieldset {
    border: none !important;
    margin: 0 !important;
    padding: 0 !important;
}
.serviceSwitch{
    padding: 10px 15px !important;
    display: flex;
    align-items: center;
    flex-direction: column;
    justify-content: space-between;
    border: 1px solid #ccc;
    padding: 20px;

}


.serviceSwitch .switch label input[type=checkbox]:checked+.lever:after {
    background-color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;

}
.serviceSwitch .switch label input[type=checkbox]:checked+.lever {
    background-color: #ccc;

}

.serviceSwitch .switch-flex{
    
    padding: 10px 15px !important;
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 20px !important;

}
.serviceSwitch h3 {
    font-size: 1.5em;
    color: <?= (is_null($color) || empty($color->getColorFirst())) ? '#000034' : $color->getColorFirst() ?> !important;
    font-weight: bold;
    display: inline-block; 
    margin: 0;
}
.serviceSwitch .switch{ 
    border: 1px solid #ccc;
    padding: 5px 10px !important;
    border-radius: 5px;
    display: block !important;
    width: max-content !important;
    margin: 0 !important;
    margin-left: 10px !important;
 
}
.serviceSwitch .flex .fa-youtube {
    background-color: #c4302b;
}

.serviceSwitch .flex svg {
    width: 55px !important;
    height: 50px;
    background-color: #000;
    color: #fff;
    padding: 10px;
    margin-right: 10px;
}
.serviceSwitch .flex label {
    width: 100%;
    float: left;
}
.serviceSwitch .flex {
    display: flex;
    align-items: center;
    flex-wrap: nowrap;
    margin: 0 ;
}
.youtube-section{
    margin-bottom: 10px!important;
}
.serviceSwitch .flex input {
    margin: 0 !important;
    background-color: white !important;
    color: #999999 !important;
    padding-left: 1em !important;
    width: calc(100% - 1em) !important;
    border: 1px solid #999 !important;
    border-left: none !important;
    font-size: .9em !important;
    height: 30px;
    box-shadow: none !important;
}
.serviceSwitch .flex span {
    height: 32px;
    line-height: 30px;
    background-color: #ccc;
    border: 1px solid #999 !important;
    color: #333;
    padding: 0 10px;
}


