<?php



require __DIR__ . '/config.php';



use Template\Entity\Config;

use Template\Controller\Web;

use CoffeeCode\Router\Router;

use Template\Controller\Lead;

use Template\Controller\Send;

use Template\Controller\Admin;

use Template\Helper\Instagram;

use Template\Controller\Brands;

use Template\Controller\Colors;

use Template\Controller\Galery;

use Template\Controller\Status;

use Template\Controller\Banners;

use Template\Controller\Configs;

use Template\Controller\Googles;

use Template\Controller\Records;

use Template\Controller\Socials;

use Template\Controller\Companys;

use Template\Controller\Question;

use Template\Controller\Services;

use Template\Controller\Qualidades;

use Template\Controller\Simulators;

use Template\Controller\Testimonys;

use Template\Controller\Denuncia;



// Injetor de Dependencia Doctrine

$container = require __DIR__ . '/dependencies.php';



// Teste de Conexão com Banco de Dados

/**try {

    $repositoryConfig = $container->getRepository(Config::class);

    $setting = $repositoryConfig->findOneBy(['id' => 1]);

} catch (\Throwable $th) {
 
    require __DIR__ . '/install.php';

    exit();

}**/



// Configuração Inicial do Sistema de Rota 

$url = (isset($setting) and !is_null($setting) && !empty($setting->getUrl())) ? $setting->getUrl() : URL_BASE;

$router = new Router($url);



// Controladores de Requisição

$web = new Web($container);

$admin = new Admin($container);

$brand = new Brands($container);

$banner = new Banners($container);

$color = new Colors($container);

$leads = new Lead($container);

$status = new Status($container);

$record = new Records($container);

$qualidade = new Qualidades($container);

$simulator = new Simulators($container);

$company = new Companys($container);

$service = new Services($container);

$galery = new Galery($container);

$testimony = new Testimonys($container);

$social = new Socials($container);

$questions = new Question($container);

$config = new Configs($container);

$google = new Googles($container);

$send = new Send($container);

$helper = new Instagram($container);

$denuncia = new Denuncia($container);


$router->namespace('src/Controller');



// Rotas principais do site

$router->group(null);

$router->get('/', function () use ($web){$web->index();});

$router->get('/thank-you', function () use ($web){$web->final();});

$router->get('/whatsapp', function () use ($web){$web->whatsapp();});



// Rotas de Envio

$router->group('/send');

$router->post('/simulator', function ($data) use ($send){$send->simulator($data);});



// Rotas de login

$router->group('/admin');

$router->get('/', function () use ($admin){$admin->index();});

$router->post('/login', function ($data) use ($admin){$admin->login($data);});

$router->post('/persist', function ($data) use ($admin){$admin->persist($data);});


if(isset($_SESSION['logado']) && $_SESSION['logado']):
    $router->get('/forgot', function () use ($admin){$admin->forgot();});
    $router->post('/forgot/persist', function ($data) use ($admin){$admin->forgotPersist($data);});

    if(isset($_SESSION['recovery']) && $_SESSION['recovery']):
        $router->get('/recovery', function () use ($admin){$admin->recovery();});
        $router->post('/recovery/persist', function ($data) use ($admin){$admin->recoveryPersist($data);});
        $router->post('/change/persist', function ($data) use ($admin){$admin->changePassword($data);});
    endif;
endif;




// Rotas do Painel Administrativo

$router->group('/dashboard');

$router->get('/', function () use ($admin){$admin->painel();});

$router->get('/logout', function () use ($admin){$admin->logout();});



// Rotas da Edição da Marca

$router->group('/brand');

$router->get('/', function () use ($brand){$brand->index();});

$router->post('/logo', function ($data) use ($brand){$brand->persistLogo($data);});
$router->post('/changesize', function ($data) use ($brand){$brand->persistOnlySize($data);});

$router->put('/logo', function ($data) use ($brand){$brand->persistLogo($data);});

$router->post('/icon', function ($data) use ($brand){$brand->persistIcon($data);});

$router->put('/icon', function ($data) use ($brand){$brand->persistIcon($data);});

$router->get('/delete/logo', function () use ($brand){$brand->deleteLogo();});

$router->get('/delete/icon', function () use ($brand){$brand->deleteIcon();});



// Rotas da Edição de Cor

$router->group('/color');

$router->get('/', function () use ($color){$color->index();});

$router->post('/persist', function ($data) use ($color){$color->persist($data);});

$router->put('/persist', function ($data) use ($color){$color->persist($data);});

$router->get('/delete', function () use ($color){$color->delete();});



// Rotas do Simulador

$router->group('/simulator');

$router->get('/', function () use ($simulator){$simulator->index();});

$router->post('/persist', function ($data) use ($simulator){$simulator->persist($data);});

$router->post('/steps', function ($data) use ($simulator){$simulator->steps($data);});

$router->delete('/delete', function ($data) use ($simulator){$simulator->delete($data);});



// Rotas de Edição do Banner

$router->group('/layout');

$router->get('/banner', function () use ($banner){$banner->index();});

$router->post('/banner/persist', function ($data) use ($banner){$banner->persist($data);});

$router->put('/banner/persist', function ($data) use ($banner){$banner->persist($data);});



// Rotas de Edição da Empresa

$router->get('/company', function () use ($company){$company->index();});

$router->post('/company/persist', function ($data) use ($company){$company->persist($data);});

$router->put('/company/persist', function ($data) use ($company){$company->persist($data);});



// Rotas do Model Service

$router->group('/service');

$router->get('/create', function () use ($service){$service->create();});

$router->post('/persist', function ($data) use ($service){$service->persist($data);});

$router->put('/persist', function ($data) use ($service){$service->update($data);});

$router->delete('/delete', function ($data) use ($service){$service->delete($data);});

$router->get('/edit/{id}', function ($data) use ($service){$service->edit($data);});

$router->get('/search', function () use ($service){$service->search();});

$router->get('/searchData', function () use ($service){$service->data();});



// Rotas de Images

$router->group('/galery');

$router->get('/', function () use ($galery){$galery->index();});

$router->post('/persist', function ($data) use ($galery){$galery->persist($data);});

$router->post('/steps', function ($data) use ($galery){$galery->steps($data);});

$router->put('/persist', function ($data) use ($galery){$galery->persist($data);});

$router->delete('/delete', function ($data) use ($galery){$galery->delete($data);});



// Rotas de Leads

$router->group('/leads');

$router->get('/', function () use ($leads){$leads->index();});

$router->get('/{id}', function ($data) use ($leads){$leads->view($data);});

$router->post('/persist', function ($data) use ($leads){$leads->persist($data);});

$router->post('/filters', function ($data) use ($leads){$leads->filter($data);});

$router->post('/change', function ($data) use ($leads){$leads->change($data);});

$router->post('/whatsapp', function ($data) use ($leads){$leads->whatsapp($data);});

$router->put('/persist', function ($data) use ($leads){$leads->persist($data);});

$router->delete('/delete', function ($data) use ($leads){$leads->delete($data);});

$router->delete('/remove', function ($data) use ($leads){$leads->remove($data);});

$router->post('/qualidade', function ($data) use ($leads){$leads->qualidade($data);});



// Rotas para Registrar Ocorrências

$router->group('/record');

$router->delete('/delete', function ($data) use ($record){$record->delete($data);});

$router->post('/persist', function ($data) use ($record){$record->persist($data);});



// Rotas Requisição de Leads

$router->group('/whatsapps');

$router->get('/', function ($data) use ($leads){$leads->index();});



// Rotas para Status

$router->group('/status');

$router->get('/', function () use ($status){$status->index(["page" => 1]);});

$router->get('/{page}', function ($data) use ($status){$status->index($data);});

$router->post('/create', function ($data) use ($status){$status->persist($data);});



// Rotas para Qualidade

$router->group('/qualidade');

$router->get('/', function ($data) use ($qualidade){$qualidade->index($data);});

$router->post('/create', function ($data) use ($qualidade){$qualidade->persist($data);});



// Rotas do Model Testimony

$router->group('/testimony');

$router->get('/create', function () use ($testimony){$testimony->create();});

$router->post('/persist', function ($data) use ($testimony){$testimony->persist($data);});

$router->put('/persist', function ($data) use ($testimony){$testimony->persist($data);});

$router->delete('/delete', function ($data) use ($testimony){$testimony->delete($data);});

$router->get('/edit/{id}', function ($data) use ($testimony){$testimony->edit($data);});

$router->get('/search', function () use ($testimony){$testimony->search();});

$router->get('/searchData', function () use ($testimony){$testimony->data();});



// Rotas do Model Question

$router->group('/questions');

$router->get('/create', function () use ($questions){$questions->create();});

$router->post('/persist', function ($data) use ($questions){$questions->persist($data);});

$router->put('/persist', function ($data) use ($questions){$questions->persist($data);});

$router->delete('/delete', function ($data) use ($questions){$questions->delete($data);});

$router->get('/edit/{id}', function ($data) use ($questions){$questions->edit($data);});

$router->get('/search', function () use ($questions){$questions->search();});

$router->get('/searchData', function () use ($questions){$questions->data();});



// Rotas da Midias Sociais

$router->group('/social');

$router->get('/', function () use ($social){$social->index();});

$router->post('/persist', function ($data) use ($social){$social->persist($data);});

$router->put('/persist', function ($data) use ($social){$social->persist($data);});



// Rotas do Model Config

$router->group('/setting');

$router->get('/', function () use ($config){$config->index();});

$router->post('/persist', function ($data) use ($config){$config->persist($data);});

$router->put('/persist', function ($data) use ($config){$config->persist($data);});

$router->post('/onlylead', function ($data) use ($config){$config->persistOnlyLead($data);});



// Rotas do Model Google

$router->group('/google');

$router->get('/', function () use ($google){$google->index();});

$router->post('/persist', function ($data) use ($google){$google->persist($data);});

$router->put('/persist', function ($data) use ($google){$google->persist($data);});


// Rotas de Denuncia Juridico Mazukim

$router->group('/denuncie');

$router->get('/', function () use ($denuncia){$denuncia->index();});
$router->post('/persist', function ($data) use ($denuncia){$denuncia->persist($data);});



// Rotas do Model Google

$router->group('/helper');

$router->post('/instagram', function ($data) use ($helper){$helper->getImage($data);});



// Redirect de segurança, caso não tenha sessão ativa

$path = $_SERVER['QUERY_STRING'];

$admin = stripos($path, 'dashboard');

if (!isset($_SESSION['logado']) && $admin > 1) {

    $router->redirect("/admin");

    exit();

}



// Rotas para Tratamento de Erros

$router->group('/error');

$router->get('/{errcode}', function ($data){

    echo "Erro: {$data['errcode']}";

});



$router->dispatch();



// Redirect de todos os erros de rotas

if ($router->error()) {

    $router->redirect("/error/{$router->error()}");

}



function caracteres_especiais($control_s) {

    //$control_s = iconv('UTF-8', 'ASCII//TRANSLIT', $control_s),

    $control_s = strtr(

        $control_s, array(

            'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A',

            'Æ' => 'A', 'Ç' => 'C', 'È' => 'E', 'É' => 'E', 'Ê' => 'E', 'Ë' => 'E',

            'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I', 'Ð' => 'D', 'Ñ' => 'N',

            'Ò' => 'O', 'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'O', 'Ø' => 'O',

            'Ù' => 'U', 'Ú' => 'U', 'Û' => 'U', 'Ü' => 'U', 'Ý' => 'Y', 'Ŕ' => 'R',

            'Þ' => 's', 'ß' => 'B', 'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a',

            'ä' => 'a', 'å' => 'a', 'æ' => 'a', 'ç' => 'c', 'è' => 'e', 'é' => 'e',

            'ê' => 'e', 'ë' => 'e', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i',

            'ð' => 'o', 'ñ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o',

            'ö' => 'o', 'ø' => 'o', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ý' => 'y',

            'þ' => 'b', 'ÿ' => 'y', 'ŕ' => 'r',

            )

        );

        $control_s = preg_replace("/[^a-zA-Z0-9\s+]/", "", $control_s);

        $control_s = preg_replace("/[\s]/", "-", $control_s);

        return strtolower($control_s);

    }